/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.io.InputStream;
import java.util.Locale;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.support.processor.MarshalProcessor;
import org.apache.camel.support.processor.UnmarshalProcessor;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public class RestProducerBindingProcessor
extends DelegateAsyncProcessor {
    private final CamelContext camelContext;
    private final AsyncProcessor jsonUnmarshal;
    private final AsyncProcessor xmlUnmarshal;
    private final AsyncProcessor jsonMarshal;
    private final AsyncProcessor xmlMarshal;
    private final String bindingMode;
    private final boolean skipBindingOnErrorCode;
    private final String outType;

    public RestProducerBindingProcessor(AsyncProcessor processor, CamelContext camelContext, DataFormat jsonDataFormat, DataFormat xmlDataFormat, DataFormat outJsonDataFormat, DataFormat outXmlDataFormat, String bindingMode, boolean skipBindingOnErrorCode, String outType) {
        super(processor);
        this.camelContext = camelContext;
        this.jsonUnmarshal = outJsonDataFormat != null ? new UnmarshalProcessor(outJsonDataFormat) : null;
        this.jsonMarshal = jsonDataFormat != null ? new MarshalProcessor(jsonDataFormat) : null;
        this.xmlUnmarshal = outXmlDataFormat != null ? new UnmarshalProcessor(outXmlDataFormat) : null;
        this.xmlMarshal = xmlDataFormat != null ? new MarshalProcessor(xmlDataFormat) : null;
        this.bindingMode = bindingMode;
        this.skipBindingOnErrorCode = skipBindingOnErrorCode;
        this.outType = outType;
    }

    public String toString() {
        return "RestProducerBindingProcessor";
    }

    protected void doStart() throws Exception {
        if (this.jsonMarshal instanceof CamelContextAware) {
            ((CamelContextAware)this.jsonMarshal).setCamelContext(this.camelContext);
        }
        if (this.jsonUnmarshal instanceof CamelContextAware) {
            ((CamelContextAware)this.jsonUnmarshal).setCamelContext(this.camelContext);
        }
        if (this.xmlMarshal instanceof CamelContextAware) {
            ((CamelContextAware)this.xmlMarshal).setCamelContext(this.camelContext);
        }
        if (this.xmlUnmarshal instanceof CamelContextAware) {
            ((CamelContextAware)this.xmlUnmarshal).setCamelContext(this.camelContext);
        }
        ServiceHelper.startService((Object[])new Object[]{this.jsonMarshal, this.jsonUnmarshal, this.xmlMarshal, this.xmlUnmarshal});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.jsonMarshal, this.jsonUnmarshal, this.xmlMarshal, this.xmlUnmarshal});
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean isXml = false;
        boolean isJson = false;
        Object body = exchange.getIn().getBody();
        if (ObjectHelper.isEmpty((Object)body)) {
            if (this.outType != null) {
                callback = new RestProducerBindingUnmarshalCallback(exchange, callback, this.jsonMarshal, this.xmlMarshal, false);
            }
            return this.getProcessor().process(exchange, callback);
        }
        if (body instanceof String || body instanceof byte[]) {
            if (this.outType != null) {
                callback = new RestProducerBindingUnmarshalCallback(exchange, callback, this.jsonMarshal, this.xmlMarshal, false);
            }
            return this.getProcessor().process(exchange, callback);
        }
        InputStream is = (InputStream)this.camelContext.getTypeConverter().tryConvertTo(InputStream.class, exchange, body);
        if (is != null) {
            exchange.getIn().setBody((Object)is);
            if (this.outType != null) {
                callback = new RestProducerBindingUnmarshalCallback(exchange, callback, this.jsonMarshal, this.xmlMarshal, false);
            }
            return this.getProcessor().process(exchange, callback);
        }
        String contentType = ExchangeHelper.getContentType((Exchange)exchange);
        if (contentType != null) {
            isXml = contentType.toLowerCase(Locale.ENGLISH).contains("xml");
            isJson = contentType.toLowerCase(Locale.ENGLISH).contains("json");
        }
        if (!(isJson &= this.bindingMode.equals("auto") || this.bindingMode.contains("json")) && !(isXml &= this.bindingMode.equals("auto") || this.bindingMode.contains("xml"))) {
            isXml = this.bindingMode.equals("auto") || this.bindingMode.contains("xml");
            boolean bl = isJson = this.bindingMode.equals("auto") || this.bindingMode.contains("json");
        }
        if (isJson && this.jsonMarshal != null) {
            try {
                this.jsonMarshal.process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
                callback.done(true);
                return true;
            }
            ExchangeHelper.prepareOutToIn((Exchange)exchange);
            if (this.outType != null) {
                callback = new RestProducerBindingUnmarshalCallback(exchange, callback, this.jsonMarshal, this.xmlMarshal, false);
            }
            return this.getProcessor().process(exchange, callback);
        }
        if (isXml && this.xmlMarshal != null) {
            try {
                this.xmlMarshal.process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
                callback.done(true);
                return true;
            }
            ExchangeHelper.prepareOutToIn((Exchange)exchange);
            if (this.outType != null) {
                callback = new RestProducerBindingUnmarshalCallback(exchange, callback, this.jsonMarshal, this.xmlMarshal, true);
            }
            return this.getProcessor().process(exchange, callback);
        }
        if ("off".equals(this.bindingMode) || this.bindingMode.equals("auto")) {
            if (this.outType != null) {
                callback = new RestProducerBindingUnmarshalCallback(exchange, callback, this.jsonMarshal, this.xmlMarshal, false);
            }
            return this.getProcessor().process(exchange, callback);
        }
        if (this.bindingMode.contains("xml")) {
            exchange.setException((Throwable)new CamelExchangeException("Cannot bind to xml as message body is not xml compatible", exchange));
        } else {
            exchange.setException((Throwable)new CamelExchangeException("Cannot bind to json as message body is not json compatible", exchange));
        }
        callback.done(true);
        return true;
    }

    private final class RestProducerBindingUnmarshalCallback
    implements AsyncCallback {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final AsyncProcessor jsonMarshal;
        private final AsyncProcessor xmlMarshal;
        private boolean wasXml;

        private RestProducerBindingUnmarshalCallback(Exchange exchange, AsyncCallback callback, AsyncProcessor jsonMarshal, AsyncProcessor xmlMarshal, boolean wasXml) {
            this.exchange = exchange;
            this.callback = callback;
            this.jsonMarshal = jsonMarshal;
            this.xmlMarshal = xmlMarshal;
            this.wasXml = wasXml;
        }

        public void done(boolean doneSync) {
            try {
                this.doDone();
            }
            catch (Exception e) {
                this.exchange.setException((Throwable)e);
            }
            finally {
                this.callback.done(doneSync);
            }
        }

        private void doDone() {
            Integer code;
            if (this.exchange.getException() != null) {
                return;
            }
            if (RestProducerBindingProcessor.this.skipBindingOnErrorCode && (code = (Integer)this.exchange.getMessage().getHeader("CamelHttpResponseCode", Integer.class)) != null && code >= 300) {
                return;
            }
            boolean isXml = false;
            boolean isJson = false;
            String contentType = ExchangeHelper.getContentType((Exchange)this.exchange);
            if (contentType != null) {
                isXml = contentType.toLowerCase(Locale.ENGLISH).contains("xml");
                isJson = contentType.toLowerCase(Locale.ENGLISH).contains("json");
            }
            if (RestProducerBindingProcessor.this.bindingMode != null && !(isJson &= RestProducerBindingProcessor.this.bindingMode.equals("off") || RestProducerBindingProcessor.this.bindingMode.equals("auto") || RestProducerBindingProcessor.this.bindingMode.contains("json")) && !(isXml &= RestProducerBindingProcessor.this.bindingMode.equals("off") || RestProducerBindingProcessor.this.bindingMode.equals("auto") || RestProducerBindingProcessor.this.bindingMode.contains("xml"))) {
                isXml = RestProducerBindingProcessor.this.bindingMode.equals("auto") || RestProducerBindingProcessor.this.bindingMode.contains("xml");
                boolean bl = isJson = RestProducerBindingProcessor.this.bindingMode.equals("auto") || RestProducerBindingProcessor.this.bindingMode.contains("json");
            }
            if (isXml && isJson) {
                isXml = this.wasXml;
                isJson = !this.wasXml;
            }
            ExchangeHelper.prepareOutToIn((Exchange)this.exchange);
            this.ensureHeaderContentType(isXml, isJson, this.exchange);
            if (RestProducerBindingProcessor.this.bindingMode == null || "off".equals(RestProducerBindingProcessor.this.bindingMode)) {
                return;
            }
            if (RestProducerBindingProcessor.this.jsonUnmarshal == null && RestProducerBindingProcessor.this.xmlUnmarshal == null) {
                return;
            }
            if (this.exchange.hasOut() && this.exchange.getOut().getBody() == null || !this.exchange.hasOut() && this.exchange.getIn().getBody() == null) {
                return;
            }
            contentType = (String)this.exchange.getIn().getHeader("Content-Type", String.class);
            contentType = contentType.toLowerCase(Locale.US);
            try {
                if (isJson && RestProducerBindingProcessor.this.jsonUnmarshal != null) {
                    if (contentType.contains("json")) {
                        RestProducerBindingProcessor.this.jsonUnmarshal.process(this.exchange);
                    }
                } else if (isXml && RestProducerBindingProcessor.this.xmlUnmarshal != null) {
                    if (contentType.contains("xml")) {
                        RestProducerBindingProcessor.this.xmlUnmarshal.process(this.exchange);
                    }
                } else if (!RestProducerBindingProcessor.this.bindingMode.equals("auto")) {
                    if (RestProducerBindingProcessor.this.bindingMode.contains("xml")) {
                        this.exchange.setException((Throwable)new CamelExchangeException("Cannot bind from xml as message body is not xml compatible", this.exchange));
                    } else {
                        this.exchange.setException((Throwable)new CamelExchangeException("Cannot bind from json as message body is not json compatible", this.exchange));
                    }
                }
            }
            catch (Exception e) {
                this.exchange.setException((Throwable)e);
            }
        }

        private void ensureHeaderContentType(boolean isXml, boolean isJson, Exchange exchange) {
            String type;
            if (isJson) {
                String type2 = ExchangeHelper.getContentType((Exchange)exchange);
                if (type2 == null) {
                    exchange.getIn().setHeader("Content-Type", (Object)"application/json");
                }
            } else if (isXml && (type = ExchangeHelper.getContentType((Exchange)exchange)) == null) {
                exchange.getIn().setHeader("Content-Type", (Object)"application/xml");
            }
        }

        public String toString() {
            return "RestProducerBindingUnmarshalCallback";
        }
    }
}

