/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.http.core.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.karaf.http.core.ServletInfo;
import org.apache.karaf.http.core.ServletService;
import org.apache.karaf.http.core.internal.ServletEventHandler;
import org.ops4j.pax.web.service.spi.ServletEvent;

public class ServletServiceImpl
implements ServletService {
    private ServletEventHandler servletEventHandler;

    public ServletServiceImpl(ServletEventHandler servletEventHandler) {
        this.servletEventHandler = servletEventHandler;
    }

    @Override
    public List<ServletInfo> getServlets() {
        ArrayList<ServletInfo> servletInfos = new ArrayList<ServletInfo>();
        List<ServletEvent> events = this.servletEventHandler.getServletEvents();
        events.sort(Comparator.comparingLong(s -> s.getBundle().getBundleId()).thenComparing(ServletEvent::getServletName));
        for (ServletEvent event : events) {
            String[] stringArray;
            String servletName;
            Servlet servlet = event.getServlet();
            String servletClassName = " ";
            if (servlet != null) {
                servletClassName = servlet.getClass().getName();
                servletClassName = servletClassName.substring(servletClassName.lastIndexOf(".") + 1);
            }
            String string = servletName = event.getServletName() != null ? event.getServletName() : " ";
            if (servletName.contains(".")) {
                servletName = servletName.substring(servletName.lastIndexOf(".") + 1);
            }
            String alias = event.getAlias();
            String[] urls = event.getUrlParameter();
            String contextPath = (String)event.getBundle().getHeaders().get("Web-ContextPath");
            if (contextPath == null) {
                contextPath = (String)event.getBundle().getHeaders().get("Webapp-Context");
            }
            if (contextPath != null) {
                if (!(contextPath = contextPath.trim()).startsWith("/")) {
                    contextPath = "/" + contextPath;
                }
                if (alias != null) {
                    alias = contextPath + alias;
                }
                if (urls != null) {
                    urls = (String[])urls.clone();
                    for (int i = 0; i < urls.length; ++i) {
                        urls[i] = urls[i].startsWith("/") ? contextPath + urls[i] : contextPath + "/" + urls[i];
                    }
                }
            }
            ServletInfo info = new ServletInfo();
            info.setBundleId(event.getBundle().getBundleId());
            info.setName(servletName);
            info.setClassName(servletClassName);
            info.setState(event.getType());
            info.setAlias(alias != null ? alias : " ");
            if (urls != null) {
                stringArray = urls;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            }
            info.setUrls(stringArray);
            servletInfos.add(info);
        }
        return servletInfos;
    }
}

