/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi.bundle.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import org.apache.xbean.osgi.bundle.util.BundleResourceFinder;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.apache.xbean.osgi.bundle.util.DelegatingBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class BundleResourceHelper {
    public static final String SEARCH_WIRED_BUNDLES = BundleResourceHelper.class.getName() + ".searchWiredBundles";
    public static final String CONVERT_RESOURCE_URLS = BundleResourceHelper.class.getName() + ".convertResourceUrls";
    private static final String META_INF_1 = "META-INF/";
    private static final String META_INF_2 = "/META-INF/";
    protected final Bundle bundle;
    private LinkedHashSet<Bundle> wiredBundles = null;
    protected boolean searchWiredBundles;
    protected boolean convertResourceUrls;

    public BundleResourceHelper(Bundle bundle) {
        this(bundle, BundleResourceHelper.getSearchWiredBundles(false), BundleResourceHelper.getConvertResourceUrls(false));
    }

    public BundleResourceHelper(Bundle bundle, boolean searchWiredBundles, boolean convertResourceUrls) {
        this.bundle = bundle;
        this.searchWiredBundles = searchWiredBundles;
        this.convertResourceUrls = convertResourceUrls;
    }

    public void setSearchWiredBundles(boolean search) {
        this.searchWiredBundles = search;
    }

    public boolean getSearchWiredBundles() {
        return this.searchWiredBundles;
    }

    public void setConvertResourceUrls(boolean convert) {
        this.convertResourceUrls = convert;
    }

    public boolean getConvertResourceUrls() {
        return this.convertResourceUrls;
    }

    public URL getResource(String name) {
        if (this.convertResourceUrls) {
            return this.convertedFindResource(name);
        }
        return this.findResource(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.convertResourceUrls) {
            return this.convertedFindResources(name);
        }
        return this.findResources(name);
    }

    protected URL convert(URL url) {
        return url;
    }

    private synchronized LinkedHashSet<Bundle> getWiredBundles() {
        if (this.wiredBundles == null) {
            this.wiredBundles = BundleUtils.getWiredBundles(this.bundle instanceof DelegatingBundle ? ((DelegatingBundle)this.bundle).getMainBundle() : this.bundle);
        }
        return this.wiredBundles;
    }

    private boolean isMetaInfResource(String name) {
        return this.searchWiredBundles && name != null && (name.startsWith(META_INF_1) || name.startsWith(META_INF_2));
    }

    private List<URL> getList() {
        if (this.convertResourceUrls) {
            return new ArrayList<URL>(){

                @Override
                public boolean add(URL u) {
                    return super.add(BundleResourceHelper.this.convert(u));
                }
            };
        }
        return new ArrayList<URL>();
    }

    private void addToList(List<URL> list, Enumeration<URL> enumeration) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                list.add(enumeration.nextElement());
            }
        }
    }

    protected URL findResource(String name) {
        URL resource = this.bundle.getResource(name);
        if (resource == null && this.isMetaInfResource(name)) {
            LinkedHashSet<Bundle> wiredBundles = this.getWiredBundles();
            Iterator iterator = wiredBundles.iterator();
            while (iterator.hasNext() && resource == null) {
                resource = ((Bundle)iterator.next()).getResource(name);
            }
        }
        if (resource != null && this.convertResourceUrls) {
            resource = this.convert(resource);
        }
        return resource;
    }

    protected Enumeration<URL> findResources(String name) throws IOException {
        Enumeration e = this.bundle.getResources(name);
        if (this.isMetaInfResource(name)) {
            List<URL> allResources = this.getList();
            this.addToList(allResources, e);
            LinkedHashSet<Bundle> wiredBundles = this.getWiredBundles();
            for (Bundle wiredBundle : wiredBundles) {
                Enumeration resources = wiredBundle.getResources(name);
                this.addToList(allResources, resources);
            }
            return Collections.enumeration(allResources);
        }
        if (e == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        if (this.convertResourceUrls) {
            List<URL> allResources = this.getList();
            this.addToList(allResources, e);
            return Collections.enumeration(allResources);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL convertedFindResource(String name) {
        ServiceReference reference = this.bundle.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)this.bundle.getBundleContext().getService(reference);
        try {
            List<URL> resources = BundleResourceHelper.findResources(packageAdmin, this.bundle, name, false);
            if (resources.isEmpty() && this.isMetaInfResource(name)) {
                LinkedHashSet<Bundle> wiredBundles = this.getWiredBundles();
                Iterator iterator = wiredBundles.iterator();
                while (iterator.hasNext() && resources.isEmpty()) {
                    Bundle wiredBundle = (Bundle)iterator.next();
                    resources = BundleResourceHelper.findResources(packageAdmin, wiredBundle, name, false);
                }
            }
            URL uRL = resources.isEmpty() ? null : resources.get(0);
            return uRL;
        }
        catch (Exception e) {
            URL uRL = null;
            return uRL;
        }
        finally {
            this.bundle.getBundleContext().ungetService(reference);
        }
    }

    protected Enumeration<URL> convertedFindResources(String name) throws IOException {
        ServiceReference reference = this.bundle.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)this.bundle.getBundleContext().getService(reference);
        try {
            List<URL> resources = BundleResourceHelper.findResources(packageAdmin, this.bundle, name, true);
            if (this.isMetaInfResource(name)) {
                LinkedHashSet<Bundle> wiredBundles = this.getWiredBundles();
                for (Bundle wiredBundle : wiredBundles) {
                    resources.addAll(BundleResourceHelper.findResources(packageAdmin, wiredBundle, name, true));
                }
            }
            Enumeration<URL> enumeration = Collections.enumeration(resources);
            return enumeration;
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error discovering resources: " + e).initCause(e);
        }
        finally {
            this.bundle.getBundleContext().ungetService(reference);
        }
    }

    private static List<URL> findResources(PackageAdmin packageAdmin, Bundle bundle, String name, final boolean continueScanning) throws Exception {
        BundleResourceFinder finder = new BundleResourceFinder(packageAdmin, bundle, "", name);
        final ArrayList<URL> resources = new ArrayList<URL>();
        finder.find(new BundleResourceFinder.ResourceFinderCallback(){

            @Override
            public boolean foundInDirectory(Bundle bundle, String baseDir, URL url) throws Exception {
                resources.add(url);
                return continueScanning;
            }

            @Override
            public boolean foundInJar(Bundle bundle, String jarName, ZipEntry entry, InputStream inputStream) throws Exception {
                URL jarURL = BundleUtils.getEntry(bundle, jarName);
                URL url = new URL("jar:" + jarURL.toString() + "!/" + entry.getName());
                resources.add(url);
                return continueScanning;
            }
        });
        return resources;
    }

    public static boolean getSearchWiredBundles(boolean defaultValue) {
        String value = System.getProperty(SEARCH_WIRED_BUNDLES);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public static boolean getConvertResourceUrls(boolean defaultValue) {
        String value = System.getProperty(CONVERT_RESOURCE_URLS);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }
}

