/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.redirect;

import aQute.bnd.exceptions.SupplierWithException;
import aQute.lib.io.IO;
import aQute.lib.redirect.Capture;
import aQute.lib.redirect.Tee;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class Redirect {
    private final InputStream stdin;
    private final OutputStream stdout;
    private final OutputStream stderr;
    private boolean captureStdout;
    private boolean captureStderr;
    private Capture cstdout;
    private Capture cstderr;

    public Redirect(InputStream stdin, OutputStream stdout, OutputStream stderr) {
        assert (stdin != System.in);
        assert (stdout != System.out);
        assert (stderr != System.err);
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public Redirect(String stdin, OutputStream stdout, OutputStream stderr) {
        this(IO.stream(stdin), stdout, stderr);
    }

    public Redirect(OutputStream stdout, OutputStream stderr) {
        this((InputStream)null, stdout, stderr);
    }

    public Redirect captureStdout() {
        this.captureStdout = true;
        return this;
    }

    public Redirect captureStderr() {
        this.captureStderr = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R apply(SupplierWithException<R> f) throws Exception {
        this.cstdout = this.captureStdout ? new Capture() : null;
        this.cstderr = this.captureStderr ? new Capture() : null;
        PrintStream teeStdout = this.build(System.out, this.stdout, this.cstdout);
        PrintStream teeStderr = this.build(System.err, this.stderr, this.cstderr);
        PrintStream orgStdout = System.out;
        PrintStream orgStderr = System.err;
        InputStream orgStdin = System.in;
        if (this.stdin != null) {
            System.setIn(this.stdin);
        }
        if (teeStdout != null) {
            System.setOut(teeStdout);
        }
        if (teeStderr != null) {
            System.setErr(teeStderr);
        }
        try {
            R r = f.get();
            return r;
        }
        finally {
            if (this.stdin != null) {
                System.setIn(orgStdin);
            }
            if (teeStdout != null) {
                System.setOut(orgStdout);
            }
            if (teeStderr != null) {
                System.setOut(orgStderr);
            }
        }
    }

    private PrintStream build(PrintStream original, OutputStream redirect, Capture capture) {
        Thread thread = Thread.currentThread();
        int n = 0;
        if (redirect != null) {
            ++n;
        }
        if (capture != null) {
            n += 2;
        }
        switch (n) {
            default: {
                return null;
            }
            case 1: {
                return new PrintStream(new Tee(original, new Tee(thread, redirect)));
            }
            case 2: {
                return new PrintStream(new Tee(original, new Tee(thread, capture)));
            }
            case 3: 
        }
        return new PrintStream(new Tee(original, new Tee(thread, redirect, capture)));
    }

    public String getStderr() {
        if (this.cstderr == null) {
            throw new IllegalArgumentException("did not capture stderr");
        }
        return this.cstderr.toString();
    }

    public String getStdout() {
        if (this.cstdout == null) {
            throw new IllegalArgumentException("did not capture stdout");
        }
        return this.cstdout.toString();
    }

    public String getContent() {
        String err;
        StringBuilder sb = new StringBuilder();
        if (this.cstdout != null) {
            sb.append(this.cstdout);
        }
        if (this.cstderr != null && (err = this.cstderr.toString()) != null && !err.isEmpty()) {
            sb.append("\n---stderr--\n");
            sb.append(err);
        }
        return sb.toString();
    }
}

