/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.karaf.shell.table.Col;

public class Row {
    private List<Object> data = new ArrayList<Object>();
    private List<String> content = new ArrayList<String>();

    Row() {
    }

    Row(List<Col> cols) {
        this();
        for (Col col : cols) {
            this.data.add(col.getHeader());
        }
    }

    public void addContent(Object ... cellDataAr) {
        this.data.addAll(Arrays.asList(cellDataAr));
    }

    void formatContent(List<Col> cols) {
        this.content.clear();
        int c = 0;
        for (Col col : cols) {
            this.content.add(col.format(this.data.get(c)));
            ++c;
        }
    }

    String getContent(List<Col> cols, String separator) {
        StringBuilder st = new StringBuilder();
        int c = 0;
        if (cols.size() != this.content.size()) {
            throw new RuntimeException("Number of columns and number of content elements do not match");
        }
        for (Col col : cols) {
            st.append(col.getContent(this.content.get(c)));
            if (c + 1 < cols.size()) {
                st.append(separator);
            }
            ++c;
        }
        return st.toString();
    }
}

