/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.config;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.config.ResequencerConfig;
import org.apache.camel.processor.resequencer.ExpressionResultComparator;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration,eip")
@XmlRootElement(name="stream-config")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class StreamResequencerConfig
extends ResequencerConfig {
    @XmlAttribute
    @Metadata(defaultValue="1000", javaType="java.lang.Integer")
    private String capacity;
    @XmlAttribute
    @Metadata(defaultValue="1000", javaType="java.time.Duration")
    private String timeout;
    @XmlAttribute
    @Metadata(defaultValue="1000", javaType="java.time.Duration")
    private String deliveryAttemptInterval;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String ignoreInvalidExchanges;
    @XmlTransient
    private ExpressionResultComparator comparator;
    @XmlAttribute
    @Metadata(label="advanced")
    private String comparatorRef;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String rejectOld;

    public StreamResequencerConfig() {
        this(1000, 1000L);
    }

    public StreamResequencerConfig(int capacity, long timeout) {
        this(capacity, timeout, null, null);
    }

    public StreamResequencerConfig(int capacity, long timeout, ExpressionResultComparator comparator) {
        this(capacity, timeout, null, comparator);
    }

    public StreamResequencerConfig(int capacity, long timeout, Boolean rejectOld) {
        this(capacity, timeout, rejectOld, null);
    }

    public StreamResequencerConfig(int capacity, long timeout, Boolean rejectOld, ExpressionResultComparator comparator) {
        this.capacity = Integer.toString(capacity);
        this.timeout = Long.toString(timeout);
        this.rejectOld = rejectOld != null ? Boolean.toString(rejectOld) : null;
        this.comparator = comparator;
    }

    public static StreamResequencerConfig getDefault() {
        return new StreamResequencerConfig();
    }

    public String getCapacity() {
        return this.capacity;
    }

    public void setCapacity(String capacity) {
        this.capacity = capacity;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getDeliveryAttemptInterval() {
        return this.deliveryAttemptInterval;
    }

    public void setDeliveryAttemptInterval(String deliveryAttemptInterval) {
        this.deliveryAttemptInterval = deliveryAttemptInterval;
    }

    public String getIgnoreInvalidExchanges() {
        return this.ignoreInvalidExchanges;
    }

    public void setIgnoreInvalidExchanges(String ignoreInvalidExchanges) {
        this.ignoreInvalidExchanges = ignoreInvalidExchanges;
    }

    public ExpressionResultComparator getComparator() {
        return this.comparator;
    }

    public void setComparator(ExpressionResultComparator comparator) {
        this.comparator = comparator;
    }

    public String getComparatorRef() {
        return this.comparatorRef;
    }

    public void setComparatorRef(String comparatorRef) {
        this.comparatorRef = comparatorRef;
    }

    public void setRejectOld(String value) {
        this.rejectOld = value;
    }

    public String getRejectOld() {
        return this.rejectOld;
    }
}

