/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.Comparator;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SortDefinition;
import org.apache.camel.processor.SortProcessor;
import org.apache.camel.reifier.ExpressionReifier;
import org.apache.camel.util.ObjectHelper;

public class SortReifier<T, U extends SortDefinition<T>>
extends ExpressionReifier<U> {
    public SortReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (SortDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        String ref = this.parseString(((SortDefinition)this.definition).getComparatorRef());
        if (ObjectHelper.isNotEmpty((Object)ref)) {
            ((SortDefinition)this.definition).setComparator(this.lookup(ref, Comparator.class));
        }
        if (((SortDefinition)this.definition).getComparator() == null) {
            ((SortDefinition)this.definition).setComparator(new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return org.apache.camel.support.ObjectHelper.compare(o1, o2);
                }
            });
        }
        Expression exp = ((SortDefinition)this.definition).getExpression() == null ? this.camelContext.resolveLanguage("simple").createExpression("${body}") : this.createExpression(((SortDefinition)this.definition).getExpression());
        return new SortProcessor(exp, ((SortDefinition)this.definition).getComparator());
    }
}

