/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import org.apache.camel.Converter;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;

@Converter(generateBulkLoader=true)
public final class CamelConverter {
    private CamelConverter() {
    }

    @Converter(order=1)
    public static Processor toProcessor(Expression expression) {
        return exchange -> {
            Object answer = expression.evaluate(exchange, Object.class);
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            out.setBody(answer);
        };
    }

    @Converter(order=2)
    public static Processor toProcessor(Predicate predicate) {
        return exchange -> {
            boolean answer = predicate.matches(exchange);
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            out.setBody((Object)answer);
        };
    }
}

