/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.transport;

import java.util.Collection;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.Disposition;
import org.apache.qpid.proton.amqp.transport.Role;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FastPathDescribedTypeConstructor;
import org.apache.qpid.proton.codec.TypeEncoding;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.codec.transport.DispositionType;

public class FastPathDispositionType
implements AMQPType<Disposition>,
FastPathDescribedTypeConstructor<Disposition> {
    private static final byte DESCRIPTOR_CODE = 21;
    private static final byte ACCEPTED_DESCRIPTOR_CODE = 36;
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf(21L), Symbol.valueOf("amqp:disposition:list")};
    private static final byte[] ACCEPTED_ENCODED_BYTES = new byte[]{0, 83, 36, 69};
    private final DispositionType dispositionType;

    public FastPathDispositionType(EncoderImpl encoder) {
        this.dispositionType = new DispositionType(encoder);
    }

    public EncoderImpl getEncoder() {
        return this.dispositionType.getEncoder();
    }

    public DecoderImpl getDecoder() {
        return this.dispositionType.getDecoder();
    }

    @Override
    public boolean encodesJavaPrimitive() {
        return false;
    }

    @Override
    public Class<Disposition> getTypeClass() {
        return Disposition.class;
    }

    @Override
    public TypeEncoding<Disposition> getEncoding(Disposition disposition) {
        return this.dispositionType.getEncoding(disposition);
    }

    @Override
    public TypeEncoding<Disposition> getCanonicalEncoding() {
        return this.dispositionType.getCanonicalEncoding();
    }

    @Override
    public Collection<? extends TypeEncoding<Disposition>> getAllEncodings() {
        return this.dispositionType.getAllEncodings();
    }

    @Override
    public Disposition readValue() {
        DecoderImpl decoder = this.getDecoder();
        byte typeCode = decoder.getBuffer().get();
        int size2 = 0;
        int count = 0;
        switch (typeCode) {
            case 69: {
                break;
            }
            case -64: {
                size2 = decoder.getBuffer().get() & 0xFF;
                count = decoder.getBuffer().get() & 0xFF;
                break;
            }
            case -48: {
                size2 = decoder.getBuffer().getInt();
                count = decoder.getBuffer().getInt();
                break;
            }
            default: {
                throw new DecodeException("Incorrect type found in Disposition encoding: " + typeCode);
            }
        }
        Disposition disposition = new Disposition();
        block13: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    disposition.setRole(Boolean.TRUE.equals(decoder.readBoolean()) ? Role.RECEIVER : Role.SENDER);
                    continue block13;
                }
                case 1: {
                    disposition.setFirst(decoder.readUnsignedInteger(null));
                    continue block13;
                }
                case 2: {
                    disposition.setLast(decoder.readUnsignedInteger(null));
                    continue block13;
                }
                case 3: {
                    disposition.setSettled(decoder.readBoolean(false));
                    continue block13;
                }
                case 4: {
                    disposition.setState((DeliveryState)decoder.readObject());
                    continue block13;
                }
                case 5: {
                    disposition.setBatchable(decoder.readBoolean(false));
                    continue block13;
                }
                default: {
                    throw new IllegalStateException("To many entries in Disposition encoding");
                }
            }
        }
        return disposition;
    }

    @Override
    public void skipValue() {
        this.getDecoder().readConstructor().skipValue();
    }

    @Override
    public void write(Disposition disposition) {
        WritableBuffer buffer = this.getEncoder().getBuffer();
        int count = this.getElementCount(disposition);
        byte encodingCode = this.deduceEncodingCode(disposition, count);
        buffer.put((byte)0);
        buffer.put((byte)83);
        buffer.put((byte)21);
        buffer.put(encodingCode);
        int fieldWidth = encodingCode == -64 ? 1 : 4;
        int startIndex = buffer.position();
        if (fieldWidth == 1) {
            buffer.put((byte)0);
            buffer.put((byte)count);
        } else {
            buffer.putInt(0);
            buffer.putInt(count);
        }
        for (int i = 0; i < count; ++i) {
            this.writeElement(disposition, i);
        }
        int endIndex = buffer.position();
        int writeSize = endIndex - startIndex - fieldWidth;
        buffer.position(startIndex);
        if (fieldWidth == 1) {
            buffer.put((byte)writeSize);
        } else {
            buffer.putInt(writeSize);
        }
        buffer.position(endIndex);
    }

    private void writeElement(Disposition disposition, int index) {
        switch (index) {
            case 0: {
                this.getEncoder().writeBoolean(disposition.getRole().getValue());
                break;
            }
            case 1: {
                this.getEncoder().writeUnsignedInteger(disposition.getFirst());
                break;
            }
            case 2: {
                this.getEncoder().writeUnsignedInteger(disposition.getLast());
                break;
            }
            case 3: {
                this.getEncoder().writeBoolean(disposition.getSettled());
                break;
            }
            case 4: {
                if (Accepted.getInstance().equals(disposition.getState())) {
                    this.getEncoder().getBuffer().put(ACCEPTED_ENCODED_BYTES, 0, ACCEPTED_ENCODED_BYTES.length);
                    break;
                }
                this.getEncoder().writeObject(disposition.getState());
                break;
            }
            case 5: {
                this.getEncoder().writeBoolean(disposition.getBatchable());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Disposition value index: " + index);
            }
        }
    }

    private int getElementCount(Disposition disposition) {
        if (disposition.getBatchable()) {
            return 6;
        }
        if (disposition.getState() != null) {
            return 5;
        }
        if (disposition.getSettled()) {
            return 4;
        }
        if (disposition.getLast() != null) {
            return 3;
        }
        return 2;
    }

    private byte deduceEncodingCode(Disposition value, int elementCount) {
        if (value.getState() == null) {
            return -64;
        }
        if (value.getState() == Accepted.getInstance() || value.getState() == Released.getInstance()) {
            return -64;
        }
        return -48;
    }

    public static void register(Decoder decoder, EncoderImpl encoder) {
        FastPathDispositionType type = new FastPathDispositionType(encoder);
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, type);
        }
        encoder.register(type);
    }
}

