/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh.keygenerator;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.util.ArrayList;
import org.apache.commons.ssl.PEMItem;
import org.apache.commons.ssl.PEMUtil;

public class PemWriter {
    private Path privateKeyPath;
    private Path publicKeyPath;

    public PemWriter(Path privateKeyPath, Path publicKeyPath) {
        this.privateKeyPath = privateKeyPath;
        this.publicKeyPath = publicKeyPath;
    }

    public void writeKeyPair(String resource, KeyPair kp) throws IOException, FileNotFoundException {
        ArrayList<PEMItem> items = new ArrayList<PEMItem>();
        items.add(new PEMItem(kp.getPrivate().getEncoded(), "PRIVATE KEY"));
        byte[] bytes = PEMUtil.encode(items);
        try (OutputStream os = Files.newOutputStream(this.privateKeyPath, new OpenOption[0]);){
            os.write(bytes);
        }
        items.clear();
        items.add(new PEMItem(kp.getPublic().getEncoded(), "PUBLIC KEY"));
        bytes = PEMUtil.encode(items);
        os = Files.newOutputStream(this.publicKeyPath, new OpenOption[0]);
        try {
            os.write(bytes);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }
}

