/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.osgi;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.spring.SpringBrokerContext;
import org.apache.activemq.spring.Utils;
import org.apache.camel.blueprint.CamelContextFactoryBean;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;

public class ActiveMQServiceFactory
implements ManagedServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQServiceFactory.class);
    BundleContext bundleContext;
    HashMap<String, BrokerService> brokers = new HashMap();

    public String getName() {
        return "ActiveMQ Server Controller";
    }

    public Map<String, BrokerService> getBrokersMap() {
        return Collections.unmodifiableMap(this.brokers);
    }

    public synchronized void updated(String pid, Dictionary properties) throws ConfigurationException {
        this.deleted(pid);
        String config = (String)properties.get("config");
        if (config == null) {
            throw new ConfigurationException("config", "Property must be set");
        }
        String name = (String)properties.get("broker-name");
        if (name == null) {
            throw new ConfigurationException("broker-name", "Property must be set");
        }
        LOG.info("Starting broker " + name);
        try {
            Thread.currentThread().setContextClassLoader(BrokerService.class.getClassLoader());
            Resource resource = Utils.resourceFromString(config);
            ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{resource.getURL().toExternalForm()}, false);
            if (this.isCamelContextFactoryBeanExist()) {
                ctx.addBeanFactoryPostProcessor(new BeanFactoryPostProcessor(){

                    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                        beanFactory.addBeanPostProcessor(new BeanPostProcessor(){

                            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                                if (bean instanceof CamelContextFactoryBean) {
                                    ((CamelContextFactoryBean)bean).setBundleContext(ActiveMQServiceFactory.this.bundleContext);
                                }
                                return bean;
                            }

                            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                                return bean;
                            }
                        });
                    }
                });
            }
            PropertyPlaceholderConfigurer configurator = new PropertyPlaceholderConfigurer();
            Properties props = new Properties();
            Enumeration elements = properties.keys();
            while (elements.hasMoreElements()) {
                Object key = elements.nextElement();
                props.put(key, properties.get(key));
            }
            configurator.setProperties(props);
            configurator.setIgnoreUnresolvablePlaceholders(true);
            ctx.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)configurator);
            ctx.refresh();
            BrokerService broker = (BrokerService)ctx.getBean(BrokerService.class);
            if (broker == null) {
                throw new ConfigurationException(null, "Broker not defined");
            }
            SpringBrokerContext brokerContext = new SpringBrokerContext();
            brokerContext.setConfigurationUrl(resource.getURL().toExternalForm());
            brokerContext.setApplicationContext((ApplicationContext)ctx);
            broker.setBrokerContext(brokerContext);
            broker.setStartAsync(true);
            broker.start();
            if (!broker.isSlave()) {
                broker.waitUntilStarted();
            }
            this.brokers.put(pid, broker);
        }
        catch (Exception e) {
            throw new ConfigurationException(null, "Cannot start the broker", (Throwable)e);
        }
    }

    private boolean isCamelContextFactoryBeanExist() {
        try {
            Class.forName("org.apache.camel.osgi.CamelContextFactoryBean");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public synchronized void deleted(String pid) {
        BrokerService broker = this.brokers.get(pid);
        if (broker == null) {
            return;
        }
        try {
            LOG.info("Stopping broker " + pid);
            broker.stop();
            broker.waitUntilStopped();
        }
        catch (Exception e) {
            LOG.error("Exception on stopping broker", (Throwable)e);
        }
    }

    public synchronized void destroy() {
        for (String broker : this.brokers.keySet()) {
            this.deleted(broker);
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

