/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.disk.journal;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Adler32;
import org.apache.activemq.store.kahadb.disk.journal.DataFile;
import org.apache.activemq.store.kahadb.disk.journal.FileAppender;
import org.apache.activemq.store.kahadb.disk.journal.Journal;
import org.apache.activemq.store.kahadb.disk.journal.Location;
import org.apache.activemq.store.kahadb.disk.journal.ReplicationTarget;
import org.apache.activemq.store.kahadb.disk.util.DataByteArrayOutputStream;
import org.apache.activemq.store.kahadb.disk.util.LinkedNodeList;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.RecoverableRandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetedDataFileAppender
implements FileAppender {
    private static final Logger LOG = LoggerFactory.getLogger(TargetedDataFileAppender.class);
    private final Journal journal;
    private final DataFile target;
    private final Map<Journal.WriteKey, Journal.WriteCommand> inflightWrites;
    private final int maxWriteBatchSize;
    private boolean closed;
    private boolean preallocate;
    private WriteBatch nextWriteBatch;
    private int statIdx = 0;
    private int[] stats = new int[maxStat];

    public TargetedDataFileAppender(Journal journal, DataFile target) {
        this.journal = journal;
        this.target = target;
        this.inflightWrites = this.journal.getInflightWrites();
        this.maxWriteBatchSize = this.journal.getWriteBatchSize();
    }

    @Override
    public Location storeItem(ByteSequence data, byte type, boolean sync) throws IOException {
        this.checkClosed();
        int size2 = data.getLength() + 5;
        Location location = new Location();
        location.setSize(size2);
        location.setType(type);
        Journal.WriteCommand write2 = new Journal.WriteCommand(location, data, sync);
        this.enqueueWrite(write2);
        if (sync) {
            this.writePendingBatch();
        }
        return location;
    }

    @Override
    public Location storeItem(ByteSequence data, byte type, Runnable onComplete2) throws IOException {
        this.checkClosed();
        int size2 = data.getLength() + 5;
        Location location = new Location();
        location.setSize(size2);
        location.setType(type);
        Journal.WriteCommand write2 = new Journal.WriteCommand(location, data, onComplete2);
        this.enqueueWrite(write2);
        return location;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (this.nextWriteBatch != null) {
                LOG.debug("Close of targeted appender flushing last batch.");
                this.writePendingBatch();
            }
            this.closed = true;
        }
    }

    public boolean isPreallocate() {
        return this.preallocate;
    }

    public void setPreallocate(boolean preallocate) {
        this.preallocate = preallocate;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("The appender is clsoed");
        }
    }

    private WriteBatch enqueueWrite(Journal.WriteCommand write2) throws IOException {
        while (true) {
            if (this.nextWriteBatch == null) {
                this.nextWriteBatch = new WriteBatch(this.target, this.target.getLength(), write2);
                break;
            }
            if (this.nextWriteBatch.canAppend(write2)) {
                this.nextWriteBatch.append(write2);
                break;
            }
            this.writePendingBatch();
            this.nextWriteBatch = null;
        }
        if (!write2.sync) {
            this.inflightWrites.put(new Journal.WriteKey(write2.location), write2);
        }
        return this.nextWriteBatch;
    }

    private void writePendingBatch() throws IOException {
        DataFile dataFile = this.nextWriteBatch.dataFile;
        try (RecoverableRandomAccessFile file = dataFile.openRandomAccessFile();
             DataByteArrayOutputStream buff = new DataByteArrayOutputStream(this.maxWriteBatchSize);){
            if (file.length() == 0L && this.isPreallocate()) {
                this.journal.preallocateEntireJournalDataFile(file);
            }
            buff.reset();
            buff.writeInt(Journal.BATCH_CONTROL_RECORD_SIZE);
            buff.writeByte(2);
            buff.write(Journal.BATCH_CONTROL_RECORD_MAGIC);
            buff.writeInt(0);
            buff.writeLong(0L);
            for (Journal.WriteCommand write2 = this.nextWriteBatch.writes.getHead(); write2 != null; write2 = (Journal.WriteCommand)write2.getNext()) {
                buff.writeInt(write2.location.getSize());
                buff.writeByte(write2.location.getType());
                buff.write(write2.data.getData(), write2.data.getOffset(), write2.data.getLength());
            }
            buff.write(Journal.EOF_RECORD);
            ByteSequence sequence = buff.toByteSequence();
            buff.reset();
            buff.skip(5 + Journal.BATCH_CONTROL_RECORD_MAGIC.length);
            buff.writeInt(sequence.getLength() - Journal.BATCH_CONTROL_RECORD_SIZE - Journal.EOF_RECORD.length);
            if (this.journal.isChecksum()) {
                Adler32 checksum = new Adler32();
                checksum.update(sequence.getData(), sequence.getOffset() + Journal.BATCH_CONTROL_RECORD_SIZE, sequence.getLength() - Journal.BATCH_CONTROL_RECORD_SIZE - Journal.EOF_RECORD.length);
                buff.writeLong(checksum.getValue());
            }
            file.seek(this.nextWriteBatch.offset);
            if (maxStat > 0) {
                if (this.statIdx < maxStat) {
                    this.stats[this.statIdx++] = sequence.getLength();
                } else {
                    long all = 0L;
                    while (this.statIdx > 0) {
                        all += (long)this.stats[--this.statIdx];
                    }
                    LOG.trace("Ave writeSize: {}", (Object)(all / (long)maxStat));
                }
            }
            file.write(sequence.getData(), sequence.getOffset(), sequence.getLength());
            ReplicationTarget replicationTarget = this.journal.getReplicationTarget();
            if (replicationTarget != null) {
                replicationTarget.replicate(this.nextWriteBatch.writes.getHead().location, sequence, true);
            }
            file.sync();
            this.signalDone(this.nextWriteBatch);
        }
        catch (IOException e) {
            LOG.info("Journal failed while writing at: {}", (Object)this.nextWriteBatch.offset);
            throw e;
        }
    }

    private void signalDone(WriteBatch writeBatch) {
        for (Journal.WriteCommand write2 = writeBatch.writes.getHead(); write2 != null; write2 = (Journal.WriteCommand)write2.getNext()) {
            if (!write2.sync) {
                this.inflightWrites.remove(new Journal.WriteKey(write2.location));
            }
            if (write2.onComplete == null) continue;
            try {
                write2.onComplete.run();
                continue;
            }
            catch (Throwable e) {
                LOG.info("Add exception was raised while executing the run command for onComplete", e);
            }
        }
    }

    public class WriteBatch {
        protected final int offset;
        public final DataFile dataFile;
        public final LinkedNodeList<Journal.WriteCommand> writes = new LinkedNodeList();
        public int size = Journal.BATCH_CONTROL_RECORD_SIZE;
        public AtomicReference<IOException> exception = new AtomicReference();

        public WriteBatch(DataFile dataFile, int offset) {
            this.dataFile = dataFile;
            this.offset = offset;
            this.dataFile.incrementLength(Journal.BATCH_CONTROL_RECORD_SIZE);
            this.size = Journal.BATCH_CONTROL_RECORD_SIZE;
            TargetedDataFileAppender.this.journal.addToTotalLength(Journal.BATCH_CONTROL_RECORD_SIZE);
        }

        public WriteBatch(DataFile dataFile, int offset, Journal.WriteCommand write2) throws IOException {
            this(dataFile, offset);
            this.append(write2);
        }

        public boolean canAppend(Journal.WriteCommand write2) {
            int newSize = this.size + write2.location.getSize();
            return newSize < TargetedDataFileAppender.this.maxWriteBatchSize;
        }

        public void append(Journal.WriteCommand write2) throws IOException {
            this.writes.addLast(write2);
            write2.location.setDataFileId(this.dataFile.getDataFileId());
            write2.location.setOffset(this.offset + this.size);
            int s = write2.location.getSize();
            this.size += s;
            this.dataFile.incrementLength(s);
            TargetedDataFileAppender.this.journal.addToTotalLength(s);
        }
    }
}

