/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound.transactionlog;

import javax.resource.ResourceException;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.transactionlog.LogXAResource;

public class LogXAResourceInsertionInterceptor
implements ConnectionInterceptor {
    private final ConnectionInterceptor next;
    private final String name;

    public LogXAResourceInsertionInterceptor(ConnectionInterceptor next, String name) {
        this.next = next;
        this.name = name;
    }

    @Override
    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        this.next.getConnection(connectionInfo);
        ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
        mci.setXAResource((XAResource)((Object)new LogXAResource(mci.getManagedConnection().getLocalTransaction(), this.name)));
    }

    @Override
    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        this.next.returnConnection(connectionInfo, connectionReturnAction);
    }

    @Override
    public void destroy() {
        this.next.destroy();
    }

    @Override
    public void info(StringBuilder s) {
        s.append(this.getClass().getName()).append("[name=").append(this.name).append("]\n");
        if (this.next == null) {
            s.append("<end>");
        } else {
            this.next.info(s);
        }
    }
}

