/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.logger;

import org.apache.felix.scr.impl.logger.InternalLogger;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

class R7LogServiceLogger
implements InternalLogger {
    private final Logger logger;

    public R7LogServiceLogger(Bundle bundle, LogService loggerFactory, String name) {
        this.logger = ((LoggerFactory)loggerFactory).getLogger(name == null ? "ROOT" : name, Logger.class);
    }

    @Override
    public boolean checkScrConfig() {
        return false;
    }

    @Override
    public boolean isLogEnabled(int level) {
        switch (level) {
            case 1: {
                return this.logger.isErrorEnabled();
            }
            case 2: {
                return this.logger.isWarnEnabled();
            }
            case 3: {
                return this.logger.isInfoEnabled();
            }
        }
        return this.logger.isDebugEnabled();
    }

    @Override
    public void log(int level, String message, Throwable ex) {
        if (ex == null) {
            switch (level) {
                case 1: {
                    this.logger.error(message);
                    break;
                }
                case 2: {
                    this.logger.warn(message);
                    break;
                }
                case 3: {
                    this.logger.info(message);
                    break;
                }
                default: {
                    this.logger.debug(message);
                    break;
                }
            }
        } else {
            switch (level) {
                case 1: {
                    this.logger.error(message, (Object)ex);
                    break;
                }
                case 2: {
                    this.logger.warn(message, (Object)ex);
                    break;
                }
                case 3: {
                    this.logger.info(message, (Object)ex);
                    break;
                }
                default: {
                    this.logger.debug(message, (Object)ex);
                }
            }
        }
    }
}

