/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.codec;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.linkedin.util.codec.Codec;
import org.linkedin.util.codec.OneWayCodec;

public class CodecUtils {
    public static String encodeString(OneWayCodec codec, String s) {
        try {
            return codec.encode(s.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String decodeString(Codec codec, String s) throws Codec.CannotDecodeException {
        try {
            return new String(codec.decode(s), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Random createRandom(String password) {
        byte[] bytes;
        if (password == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            bytes = md.digest(password.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        int len = bytes.length;
        if (len > 6) {
            len = 6;
        }
        long seed = 0L;
        if (len > 0) {
            seed = bytes[0];
            for (int i = 1; i < len; ++i) {
                seed <<= 8;
                seed |= (long)bytes[i];
            }
        }
        int k = 0;
        for (int i = len; i < bytes.length; ++i) {
            seed ^= (long)bytes[i] << k * 8;
            if (k++ != 5) continue;
            k = 0;
        }
        return new Random(seed);
    }

    private CodecUtils() {
    }
}

