/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtbuf.proto;

import java.util.Collections;
import java.util.List;
import org.fusesource.hawtbuf.proto.InvalidProtocolBufferException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UninitializedMessageException
extends RuntimeException {
    private final List<String> missingFields;

    public UninitializedMessageException(List<String> missingFields) {
        super(UninitializedMessageException.buildDescription(missingFields));
        this.missingFields = missingFields;
    }

    public List<String> getMissingFields() {
        return Collections.unmodifiableList(this.missingFields);
    }

    public InvalidProtocolBufferException asInvalidProtocolBufferException() {
        return new InvalidProtocolBufferException(this.getMessage());
    }

    private static String buildDescription(List<String> missingFields) {
        StringBuilder description = new StringBuilder("Message missing required fields: ");
        boolean first = true;
        for (String field : missingFields) {
            if (first) {
                first = false;
            } else {
                description.append(", ");
            }
            description.append(field);
        }
        return description.toString();
    }
}

