/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh.keygenerator;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.ssl.PKCS8Key;
import org.apache.karaf.shell.ssh.keygenerator.OpenSSHKeyPairGenerator;
import org.apache.karaf.shell.ssh.keygenerator.PemWriter;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSSHKeyPairProvider
extends AbstractKeyPairProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSSHKeyPairProvider.class);
    private Path privateKeyPath;
    private Path publicKeyPath;
    private String password;
    private KeyPair cachedKey;
    private String algorithm;
    private int keySize;

    public OpenSSHKeyPairProvider(Path privateKeyPath, Path publicKeyPath, String algorithm, int keySize) {
        this.privateKeyPath = privateKeyPath;
        this.publicKeyPath = publicKeyPath;
        this.algorithm = algorithm;
        this.keySize = keySize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Iterable<KeyPair> loadKeys(SessionContext sessionContext) throws IOException, GeneralSecurityException {
        if (this.cachedKey != null) {
            return Collections.singleton(this.cachedKey);
        }
        if (!this.privateKeyPath.toFile().exists()) {
            this.createServerKey();
        }
        try (InputStream is = Files.newInputStream(this.privateKeyPath, new OpenOption[0]);){
            KeyPair kp;
            this.cachedKey = kp = this.getKeyPair(is);
            Set<KeyPair> set = Collections.singleton(kp);
            return set;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to parse keypair in {}. Attempting to parse it 'directly'", (Object)this.privateKeyPath);
            try {
                KeyPair kp2 = this.getKeyPairUsingPublicKeyFile();
                LOGGER.info("Successfully loaded key pair");
                this.cachedKey = kp2;
                return Collections.singleton(this.cachedKey);
            }
            catch (IOException | IllegalArgumentException | NoSuchAlgorithmException | InvalidKeySpecException e1) {
                LOGGER.warn("Failed to parse keypair in {}. Attempting to parse it as a legacy 'simple' key", (Object)this.privateKeyPath);
                try {
                    KeyPair kp3 = this.convertLegacyKey(this.privateKeyPath);
                    LOGGER.info("Successfully loaded legacy simple key. Converted to PEM format");
                    this.cachedKey = kp3;
                    return Collections.singleton(kp3);
                }
                catch (Exception nested) {
                    LOGGER.warn(this.privateKeyPath + " is not a 'simple' key either", (Throwable)nested);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private KeyPair getKeyPair(InputStream is) throws GeneralSecurityException, IOException {
        PKCS8Key pkcs8 = new PKCS8Key(is, this.password == null ? null : this.password.toCharArray());
        return new KeyPair(pkcs8.getPublicKey(), pkcs8.getPrivateKey());
    }

    private KeyPair convertLegacyKey(Path privateKeyPath) throws GeneralSecurityException, IOException {
        KeyPair keypair = null;
        try (KeyPairObjectInputStream r = new KeyPairObjectInputStream(Files.newInputStream(privateKeyPath, new OpenOption[0]));){
            keypair = (KeyPair)r.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new InvalidKeySpecException("Missing classes: " + e.getMessage(), e);
        }
        new PemWriter(privateKeyPath, this.publicKeyPath).writeKeyPair(this.algorithm, keypair);
        return keypair;
    }

    private KeyPair getKeyPairUsingPublicKeyFile() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(this.algorithm);
        String content = new String(Files.readAllBytes(this.privateKeyPath), StandardCharsets.UTF_8);
        content = content.replace("-----BEGIN PRIVATE KEY-----", "");
        content = content.replace("-----END PRIVATE KEY-----", "");
        PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(Base64.getMimeDecoder().decode(content));
        PrivateKey privateKey = keyFactory.generatePrivate(encodedKeySpec);
        content = new String(Files.readAllBytes(this.publicKeyPath), StandardCharsets.UTF_8);
        content = content.replace("-----BEGIN PUBLIC KEY-----", "");
        content = content.replace("-----END PUBLIC KEY-----", "");
        X509EncodedKeySpec encodedX509KeySpec = new X509EncodedKeySpec(Base64.getMimeDecoder().decode(content));
        PublicKey publicKey = keyFactory.generatePublic(encodedX509KeySpec);
        return new KeyPair(publicKey, privateKey);
    }

    private KeyPair createServerKey() {
        try {
            LOGGER.info("Creating ssh server private key at " + this.privateKeyPath);
            KeyPair kp = new OpenSSHKeyPairGenerator(this.algorithm, this.keySize).generate();
            new PemWriter(this.privateKeyPath, this.publicKeyPath).writeKeyPair(this.algorithm, kp);
            return kp;
        }
        catch (Exception e) {
            throw new RuntimeException("Key file generation failed", e);
        }
    }

    private static class KeyPairObjectInputStream
    extends ObjectInputStream {
        private boolean valid;

        public KeyPairObjectInputStream(InputStream is) throws IOException {
            super(is);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (!this.valid) {
                if (!desc.getName().equals(KeyPair.class.getName())) {
                    throw new InvalidClassException("Unauthorized deserialization attempt", desc.getName());
                }
                this.valid = true;
            }
            return super.resolveClass(desc);
        }
    }
}

