/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.ConnectionMetaData;

public final class ActiveMQConnectionMetaData
implements ConnectionMetaData {
    public static final String PROVIDER_VERSION;
    public static final int PROVIDER_MAJOR_VERSION;
    public static final int PROVIDER_MINOR_VERSION;
    public static final String PROVIDER_NAME = "ActiveMQ";
    public static final String DEFAULT_PLATFORM_DETAILS = "Java";
    public static final String PLATFORM_DETAILS;
    public static final ActiveMQConnectionMetaData INSTANCE;

    private ActiveMQConnectionMetaData() {
    }

    public String getJMSVersion() {
        return "1.1";
    }

    public int getJMSMajorVersion() {
        return 1;
    }

    public int getJMSMinorVersion() {
        return 1;
    }

    public String getJMSProviderName() {
        return PROVIDER_NAME;
    }

    public String getProviderVersion() {
        return PROVIDER_VERSION;
    }

    public int getProviderMajorVersion() {
        return PROVIDER_MAJOR_VERSION;
    }

    public int getProviderMinorVersion() {
        return PROVIDER_MINOR_VERSION;
    }

    public Enumeration<String> getJMSXPropertyNames() {
        Vector<String> jmxProperties = new Vector<String>();
        jmxProperties.add("JMSXUserID");
        jmxProperties.add("JMSXGroupID");
        jmxProperties.add("JMSXGroupSeq");
        jmxProperties.add("JMSXDeliveryCount");
        jmxProperties.add("JMSXProducerTXID");
        return jmxProperties.elements();
    }

    private static String getPlatformDetails() {
        String details = "java";
        try {
            StringBuilder platformInfo = new StringBuilder(128);
            platformInfo.append("JVM: ");
            platformInfo.append(System.getProperty("java.version"));
            platformInfo.append(", ");
            platformInfo.append(System.getProperty("java.vm.version"));
            platformInfo.append(", ");
            platformInfo.append(System.getProperty("java.vendor"));
            platformInfo.append(", OS: ");
            platformInfo.append(System.getProperty("os.name"));
            platformInfo.append(", ");
            platformInfo.append(System.getProperty("os.version"));
            platformInfo.append(", ");
            platformInfo.append(System.getProperty("os.arch"));
            details = platformInfo.toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return details;
    }

    static {
        INSTANCE = new ActiveMQConnectionMetaData();
        String version = null;
        int major = 0;
        int minor = 0;
        try {
            Pattern pattern;
            Matcher m;
            Package p = Package.getPackage("org.apache.activemq");
            if (p != null && (version = p.getImplementationVersion()) != null && (m = (pattern = Pattern.compile("(\\d+)\\.(\\d+).*")).matcher(version)).matches()) {
                major = Integer.parseInt(m.group(1));
                minor = Integer.parseInt(m.group(2));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PROVIDER_VERSION = version;
        PROVIDER_MAJOR_VERSION = major;
        PROVIDER_MINOR_VERSION = minor;
        PLATFORM_DETAILS = ActiveMQConnectionMetaData.getPlatformDetails();
    }
}

