/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.camel.commands.AbstractContextCommand;
import org.apache.camel.commands.CamelController;

public class ContextInflightCommand
extends AbstractContextCommand {
    private static final String EXCHANGE_COLUMN_LABEL = "ExchangeId";
    private static final String FROM_ROUTE_COLUMN_LABEL = "From Route";
    private static final String ROUTE_COLUMN_LABEL = "Route";
    private static final String NODE_COLUMN_LABEL = "Node";
    private static final String ELAPSED_COLUMN_LABEL = "Elapsed (ms)";
    private static final String DURATION_COLUMN_LABEL = "Duration (ms)";
    private static final int DEFAULT_COLUMN_WIDTH_INCREMENT = 0;
    private static final String DEFAULT_FIELD_PREAMBLE = " ";
    private static final String DEFAULT_FIELD_POSTAMBLE = " ";
    private static final String DEFAULT_HEADER_PREAMBLE = " ";
    private static final String DEFAULT_HEADER_POSTAMBLE = " ";
    private static final int DEFAULT_FORMAT_BUFFER_LENGTH = 24;
    private static final int MAX_COLUMN_WIDTH = Integer.MAX_VALUE;
    private static final int MIN_COLUMN_WIDTH = 12;
    private int limit;
    private String route;
    private boolean sortByLongestDuration;

    public ContextInflightCommand(String context, String route, int limit, boolean sortByLongestDuration) {
        super(context);
        this.route = route;
        this.limit = limit;
        this.sortByLongestDuration = sortByLongestDuration;
    }

    @Override
    protected Object performContextCommand(CamelController camelController, String contextName, PrintStream out, PrintStream err) throws Exception {
        List<Map<String, Object>> inflight = camelController.browseInflightExchanges(contextName, this.route, this.limit, this.sortByLongestDuration);
        Map<String, Integer> columnWidths = this.computeColumnWidths(inflight);
        String headerFormat = ContextInflightCommand.buildFormatString(columnWidths, true);
        String rowFormat = ContextInflightCommand.buildFormatString(columnWidths, false);
        if (inflight.size() > 0) {
            out.println(String.format(headerFormat, EXCHANGE_COLUMN_LABEL, FROM_ROUTE_COLUMN_LABEL, ROUTE_COLUMN_LABEL, NODE_COLUMN_LABEL, ELAPSED_COLUMN_LABEL, DURATION_COLUMN_LABEL));
            out.println(String.format(headerFormat, "----------", "----------", "-----", "----", "------------", "-------------"));
            for (Map<String, Object> row : inflight) {
                Object exchangeId = row.get("exchangeId");
                Object fromRouteId = row.get("fromRouteId");
                Object routeId = row.get("routeId");
                Object nodeId = row.get("nodeId");
                Object elapsed = row.get("elapsed");
                Object duration = row.get("duration");
                out.println(String.format(rowFormat, exchangeId, fromRouteId, routeId, nodeId, this.safeNull(elapsed), this.safeNull(duration)));
            }
        }
        return null;
    }

    private Map<String, Integer> computeColumnWidths(Iterable<Map<String, Object>> inflight) throws Exception {
        if (inflight == null) {
            throw new IllegalArgumentException("Unable to determine column widths from null Iterable<Inflight>");
        }
        int maxExchangeLen = 0;
        int maxFromRouteLen = 0;
        int maxRouteLen = 0;
        int maxNodeLen = 0;
        int maxElapsedLen = 0;
        int maxDurationLen = 0;
        for (Map<String, Object> row : inflight) {
            String exchangeId = this.safeNull(row.get("exchangeId"));
            maxExchangeLen = Math.max(maxExchangeLen, exchangeId == null ? 0 : exchangeId.length());
            String fromRouteId = this.safeNull(row.get("fromRouteId"));
            maxFromRouteLen = Math.max(maxFromRouteLen, fromRouteId == null ? 0 : fromRouteId.length());
            String routeId = this.safeNull(row.get("routeId"));
            maxRouteLen = Math.max(maxRouteLen, routeId == null ? 0 : routeId.length());
            String nodeId = this.safeNull(row.get("nodeId"));
            maxNodeLen = Math.max(maxNodeLen, nodeId == null ? 0 : nodeId.length());
            String elapsed = this.safeNull(row.get("elapsed"));
            maxElapsedLen = Math.max(maxElapsedLen, elapsed == null ? 0 : elapsed.length());
            String duration = this.safeNull(row.get("duration"));
            maxDurationLen = Math.max(maxDurationLen, duration == null ? 0 : duration.length());
        }
        Hashtable<String, Integer> retval = new Hashtable<String, Integer>(5);
        retval.put(EXCHANGE_COLUMN_LABEL, maxExchangeLen);
        retval.put(FROM_ROUTE_COLUMN_LABEL, maxFromRouteLen);
        retval.put(ROUTE_COLUMN_LABEL, maxRouteLen);
        retval.put(NODE_COLUMN_LABEL, maxNodeLen);
        retval.put(ELAPSED_COLUMN_LABEL, maxElapsedLen);
        retval.put(DURATION_COLUMN_LABEL, maxDurationLen);
        return retval;
    }

    private static String buildFormatString(Map<String, Integer> columnWidths, boolean isHeader) {
        String fieldPostamble;
        String fieldPreamble;
        if (isHeader) {
            fieldPreamble = " ";
            fieldPostamble = " ";
        } else {
            fieldPreamble = " ";
            fieldPostamble = " ";
        }
        int columnWidthIncrement = 0;
        int exchangeLen = Math.min(columnWidths.get(EXCHANGE_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        int fromRouteLen = Math.min(columnWidths.get(FROM_ROUTE_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        int routeLen = Math.min(columnWidths.get(ROUTE_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        int nodeLen = Math.min(columnWidths.get(NODE_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        int elapsedLen = Math.min(columnWidths.get(ELAPSED_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        int durationLen = Math.min(columnWidths.get(DURATION_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        exchangeLen = Math.max(12, exchangeLen);
        fromRouteLen = Math.max(12, fromRouteLen);
        routeLen = Math.max(12, routeLen);
        nodeLen = Math.max(12, nodeLen);
        elapsedLen = Math.max(12, elapsedLen);
        durationLen = Math.max(13, durationLen);
        StringBuilder retval = new StringBuilder(24);
        retval.append(fieldPreamble).append("%-").append(exchangeLen).append('.').append(exchangeLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(fromRouteLen).append('.').append(fromRouteLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(routeLen).append('.').append(routeLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(nodeLen).append('.').append(nodeLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%").append(elapsedLen).append('.').append(elapsedLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%").append(durationLen).append('.').append(durationLen).append('s').append(fieldPostamble).append(' ');
        return retval.toString();
    }
}

