/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public class FrameWriterBuffer
implements WritableBuffer {
    public static final int DEFAULT_CAPACITY = 1024;
    byte[] array;
    int position;

    public FrameWriterBuffer() {
        this(1024);
    }

    public FrameWriterBuffer(int capacity) {
        this.array = new byte[capacity];
    }

    public byte[] array() {
        return this.array;
    }

    public int arrayOffset() {
        return 0;
    }

    @Override
    public void put(byte b) {
        this.ensureRemaining(1);
        this.array[this.position++] = b;
    }

    @Override
    public void putShort(short value) {
        this.ensureRemaining(2);
        this.array[this.position++] = (byte)(value >>> 8);
        this.array[this.position++] = (byte)(value >>> 0);
    }

    @Override
    public void putInt(int value) {
        this.ensureRemaining(4);
        this.array[this.position++] = (byte)(value >>> 24);
        this.array[this.position++] = (byte)(value >>> 16);
        this.array[this.position++] = (byte)(value >>> 8);
        this.array[this.position++] = (byte)(value >>> 0);
    }

    @Override
    public void putLong(long value) {
        this.ensureRemaining(8);
        this.array[this.position++] = (byte)(value >>> 56);
        this.array[this.position++] = (byte)(value >>> 48);
        this.array[this.position++] = (byte)(value >>> 40);
        this.array[this.position++] = (byte)(value >>> 32);
        this.array[this.position++] = (byte)(value >>> 24);
        this.array[this.position++] = (byte)(value >>> 16);
        this.array[this.position++] = (byte)(value >>> 8);
        this.array[this.position++] = (byte)(value >>> 0);
    }

    @Override
    public void putFloat(float value) {
        this.putInt(Float.floatToRawIntBits(value));
    }

    @Override
    public void putDouble(double value) {
        this.putLong(Double.doubleToRawLongBits(value));
    }

    @Override
    public void put(byte[] src, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.ensureRemaining(length);
        System.arraycopy(src, offset, this.array, this.position, length);
        this.position += length;
    }

    @Override
    public void put(ByteBuffer payload) {
        int toCopy = payload.remaining();
        this.ensureRemaining(toCopy);
        if (payload.hasArray()) {
            System.arraycopy(payload.array(), payload.arrayOffset() + payload.position(), this.array, this.position, toCopy);
            payload.position(payload.position() + toCopy);
        } else {
            payload.get(this.array, this.position, toCopy);
        }
        this.position += toCopy;
    }

    @Override
    public void put(ReadableBuffer payload) {
        int toCopy = payload.remaining();
        this.ensureRemaining(toCopy);
        if (payload.hasArray()) {
            System.arraycopy(payload.array(), payload.arrayOffset() + payload.position(), this.array, this.position, toCopy);
            payload.position(payload.position() + toCopy);
        } else {
            payload.get(this.array, this.position, toCopy);
        }
        this.position += toCopy;
    }

    @Override
    public boolean hasRemaining() {
        return this.position < Integer.MAX_VALUE;
    }

    @Override
    public int remaining() {
        return Integer.MAX_VALUE - this.position;
    }

    @Override
    public void ensureRemaining(int requiredRemaining) {
        if (requiredRemaining > this.array.length - this.position) {
            byte[] newBuffer = new byte[Math.max(this.array.length << 1, requiredRemaining + this.position)];
            System.arraycopy(this.array, 0, newBuffer, 0, this.array.length);
            this.array = newBuffer;
        }
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void position(int position) {
        if (position < 0) {
            throw new IllegalArgumentException("Requested new buffer position cannot be negative");
        }
        if (position > this.array.length) {
            this.ensureRemaining(position - this.array.length);
        }
        this.position = position;
    }

    @Override
    public int limit() {
        return Integer.MAX_VALUE;
    }

    public int transferTo(ByteBuffer target) {
        int size2 = Math.min(this.position, target.remaining());
        if (size2 == 0) {
            return 0;
        }
        if (target.hasArray()) {
            System.arraycopy(this.array, 0, target.array(), target.arrayOffset() + target.position(), size2);
            target.position(target.position() + size2);
        } else {
            target.put(this.array, 0, size2);
        }
        if (size2 != this.position) {
            int remainder = this.position - size2;
            System.arraycopy(this.array, size2, this.array, 0, remainder);
            this.position = remainder;
        } else {
            this.position = 0;
        }
        return size2;
    }
}

