/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.Open;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.ProtonJConnection;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.impl.CollectorImpl;
import org.apache.qpid.proton.engine.impl.DeliveryImpl;
import org.apache.qpid.proton.engine.impl.EndpointImpl;
import org.apache.qpid.proton.engine.impl.EndpointImplQuery;
import org.apache.qpid.proton.engine.impl.EventImpl;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.LinkNode;
import org.apache.qpid.proton.engine.impl.SessionImpl;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.reactor.Reactor;

public class ConnectionImpl
extends EndpointImpl
implements ProtonJConnection {
    public static final int MAX_CHANNELS = 65535;
    private List<SessionImpl> _sessions = new ArrayList<SessionImpl>();
    private EndpointImpl _transportTail;
    private EndpointImpl _transportHead;
    private int _maxChannels = 65535;
    private LinkNode<SessionImpl> _sessionHead;
    private LinkNode<SessionImpl> _sessionTail;
    private LinkNode<LinkImpl> _linkHead;
    private LinkNode<LinkImpl> _linkTail;
    private DeliveryImpl _workHead;
    private DeliveryImpl _workTail;
    private TransportImpl _transport;
    private DeliveryImpl _transportWorkHead;
    private DeliveryImpl _transportWorkTail;
    private int _transportWorkSize = 0;
    private String _localContainerId = "";
    private String _localHostname;
    private String _remoteContainer;
    private String _remoteHostname;
    private Symbol[] _offeredCapabilities;
    private Symbol[] _desiredCapabilities;
    private Symbol[] _remoteOfferedCapabilities;
    private Symbol[] _remoteDesiredCapabilities;
    private Map<Symbol, Object> _properties;
    private Map<Symbol, Object> _remoteProperties;
    private Object _context;
    private CollectorImpl _collector;
    private Reactor _reactor;
    private static final Symbol[] EMPTY_SYMBOL_ARRAY = new Symbol[0];

    @Override
    public SessionImpl session() {
        SessionImpl session = new SessionImpl(this);
        this._sessions.add(session);
        return session;
    }

    void freeSession(SessionImpl session) {
        this._sessions.remove(session);
    }

    protected LinkNode<SessionImpl> addSessionEndpoint(SessionImpl endpoint) {
        LinkNode<SessionImpl> node;
        if (this._sessionHead == null) {
            this._sessionTail = LinkNode.newList(endpoint);
            this._sessionHead = this._sessionTail;
            node = this._sessionTail;
        } else {
            this._sessionTail = this._sessionTail.addAtTail(endpoint);
            node = this._sessionTail;
        }
        return node;
    }

    void removeSessionEndpoint(LinkNode<SessionImpl> node) {
        LinkNode<SessionImpl> prev = node.getPrev();
        LinkNode<SessionImpl> next = node.getNext();
        if (this._sessionHead == node) {
            this._sessionHead = next;
        }
        if (this._sessionTail == node) {
            this._sessionTail = prev;
        }
        node.remove();
    }

    protected LinkNode<LinkImpl> addLinkEndpoint(LinkImpl endpoint) {
        LinkNode<LinkImpl> node;
        if (this._linkHead == null) {
            this._linkTail = LinkNode.newList(endpoint);
            this._linkHead = this._linkTail;
            node = this._linkTail;
        } else {
            this._linkTail = this._linkTail.addAtTail(endpoint);
            node = this._linkTail;
        }
        return node;
    }

    void removeLinkEndpoint(LinkNode<LinkImpl> node) {
        LinkNode<LinkImpl> prev = node.getPrev();
        LinkNode<LinkImpl> next = node.getNext();
        if (this._linkHead == node) {
            this._linkHead = next;
        }
        if (this._linkTail == node) {
            this._linkTail = prev;
        }
        node.remove();
    }

    @Override
    public Session sessionHead(EnumSet<EndpointState> local, EnumSet<EndpointState> remote) {
        if (this._sessionHead == null) {
            return null;
        }
        EndpointImplQuery<SessionImpl> query = new EndpointImplQuery<SessionImpl>(local, remote);
        LinkNode<SessionImpl> node = query.matches(this._sessionHead) ? this._sessionHead : this._sessionHead.next(query);
        return node == null ? null : (Session)node.getValue();
    }

    @Override
    public Link linkHead(EnumSet<EndpointState> local, EnumSet<EndpointState> remote) {
        if (this._linkHead == null) {
            return null;
        }
        EndpointImplQuery<LinkImpl> query = new EndpointImplQuery<LinkImpl>(local, remote);
        LinkNode<LinkImpl> node = query.matches(this._linkHead) ? this._linkHead : this._linkHead.next(query);
        return node == null ? null : (Link)node.getValue();
    }

    @Override
    protected ConnectionImpl getConnectionImpl() {
        return this;
    }

    @Override
    void postFinal() {
        this.put(Event.Type.CONNECTION_FINAL, this);
    }

    @Override
    void doFree() {
        ArrayList<SessionImpl> sessions = new ArrayList<SessionImpl>(this._sessions);
        for (Session session : sessions) {
            session.free();
        }
        this._sessions = null;
    }

    void modifyEndpoints() {
        if (this._sessions != null) {
            for (SessionImpl ssn : this._sessions) {
                ssn.modifyEndpoints();
            }
        }
        if (!this.freed) {
            this.modified();
        }
    }

    void handleOpen(Open open2) {
        this.setRemoteState(EndpointState.ACTIVE);
        this.setRemoteHostname(open2.getHostname());
        this.setRemoteContainer(open2.getContainerId());
        this.setRemoteDesiredCapabilities(open2.getDesiredCapabilities());
        this.setRemoteOfferedCapabilities(open2.getOfferedCapabilities());
        this.setRemoteProperties(open2.getProperties());
        this.put(Event.Type.CONNECTION_REMOTE_OPEN, this);
    }

    EndpointImpl getTransportHead() {
        return this._transportHead;
    }

    EndpointImpl getTransportTail() {
        return this._transportTail;
    }

    void addModified(EndpointImpl endpoint) {
        if (this._transportTail == null) {
            endpoint.setTransportNext(null);
            endpoint.setTransportPrev(null);
            this._transportHead = this._transportTail = endpoint;
        } else {
            this._transportTail.setTransportNext(endpoint);
            endpoint.setTransportPrev(this._transportTail);
            this._transportTail = endpoint;
            this._transportTail.setTransportNext(null);
        }
    }

    void removeModified(EndpointImpl endpoint) {
        if (this._transportHead == endpoint) {
            this._transportHead = endpoint.transportNext();
        } else {
            endpoint.transportPrev().setTransportNext(endpoint.transportNext());
        }
        if (this._transportTail == endpoint) {
            this._transportTail = endpoint.transportPrev();
        } else {
            endpoint.transportNext().setTransportPrev(endpoint.transportPrev());
        }
    }

    @Override
    public int getMaxChannels() {
        return this._maxChannels;
    }

    public String getLocalContainerId() {
        return this._localContainerId;
    }

    @Override
    public void setLocalContainerId(String localContainerId) {
        this._localContainerId = localContainerId;
    }

    @Override
    public DeliveryImpl getWorkHead() {
        return this._workHead;
    }

    @Override
    public void setContainer(String container) {
        this._localContainerId = container;
    }

    @Override
    public String getContainer() {
        return this._localContainerId;
    }

    @Override
    public void setHostname(String hostname) {
        this._localHostname = hostname;
    }

    @Override
    public String getRemoteContainer() {
        return this._remoteContainer;
    }

    @Override
    public String getRemoteHostname() {
        return this._remoteHostname;
    }

    @Override
    public void setOfferedCapabilities(Symbol[] capabilities) {
        this._offeredCapabilities = capabilities;
    }

    @Override
    public void setDesiredCapabilities(Symbol[] capabilities) {
        this._desiredCapabilities = capabilities;
    }

    @Override
    public Symbol[] getRemoteOfferedCapabilities() {
        return this._remoteOfferedCapabilities == null ? EMPTY_SYMBOL_ARRAY : this._remoteOfferedCapabilities;
    }

    @Override
    public Symbol[] getRemoteDesiredCapabilities() {
        return this._remoteDesiredCapabilities == null ? EMPTY_SYMBOL_ARRAY : this._remoteDesiredCapabilities;
    }

    Symbol[] getOfferedCapabilities() {
        return this._offeredCapabilities;
    }

    Symbol[] getDesiredCapabilities() {
        return this._desiredCapabilities;
    }

    void setRemoteOfferedCapabilities(Symbol[] remoteOfferedCapabilities) {
        this._remoteOfferedCapabilities = remoteOfferedCapabilities;
    }

    void setRemoteDesiredCapabilities(Symbol[] remoteDesiredCapabilities) {
        this._remoteDesiredCapabilities = remoteDesiredCapabilities;
    }

    Map<Symbol, Object> getProperties() {
        return this._properties;
    }

    @Override
    public void setProperties(Map<Symbol, Object> properties) {
        this._properties = properties;
    }

    @Override
    public Map<Symbol, Object> getRemoteProperties() {
        return this._remoteProperties;
    }

    void setRemoteProperties(Map<Symbol, Object> remoteProperties) {
        this._remoteProperties = remoteProperties;
    }

    @Override
    public String getHostname() {
        return this._localHostname;
    }

    void setRemoteContainer(String remoteContainerId) {
        this._remoteContainer = remoteContainerId;
    }

    void setRemoteHostname(String remoteHostname) {
        this._remoteHostname = remoteHostname;
    }

    DeliveryImpl getWorkTail() {
        return this._workTail;
    }

    void removeWork(DeliveryImpl delivery) {
        if (!delivery._work) {
            return;
        }
        DeliveryImpl next = delivery.getWorkNext();
        DeliveryImpl prev = delivery.getWorkPrev();
        if (prev != null) {
            prev.setWorkNext(next);
        }
        if (next != null) {
            next.setWorkPrev(prev);
        }
        delivery.setWorkNext(null);
        delivery.setWorkPrev(null);
        if (this._workHead == delivery) {
            this._workHead = next;
        }
        if (this._workTail == delivery) {
            this._workTail = prev;
        }
        delivery._work = false;
    }

    void addWork(DeliveryImpl delivery) {
        if (delivery._work) {
            return;
        }
        delivery.setWorkNext(null);
        delivery.setWorkPrev(this._workTail);
        if (this._workTail != null) {
            this._workTail.setWorkNext(delivery);
        }
        this._workTail = delivery;
        if (this._workHead == null) {
            this._workHead = delivery;
        }
        delivery._work = true;
    }

    public Iterator<DeliveryImpl> getWorkSequence() {
        return new WorkSequence(this._workHead);
    }

    void setTransport(TransportImpl transport) {
        this._transport = transport;
    }

    @Override
    public TransportImpl getTransport() {
        return this._transport;
    }

    DeliveryImpl getTransportWorkHead() {
        return this._transportWorkHead;
    }

    int getTransportWorkSize() {
        return this._transportWorkSize;
    }

    public void removeTransportWork(DeliveryImpl delivery) {
        if (!delivery._transportWork) {
            return;
        }
        DeliveryImpl next = delivery.getTransportWorkNext();
        DeliveryImpl prev = delivery.getTransportWorkPrev();
        if (prev != null) {
            prev.setTransportWorkNext(next);
        }
        if (next != null) {
            next.setTransportWorkPrev(prev);
        }
        delivery.setTransportWorkNext(null);
        delivery.setTransportWorkPrev(null);
        if (this._transportWorkHead == delivery) {
            this._transportWorkHead = next;
        }
        if (this._transportWorkTail == delivery) {
            this._transportWorkTail = prev;
        }
        delivery._transportWork = false;
        --this._transportWorkSize;
    }

    void addTransportWork(DeliveryImpl delivery) {
        this.modified();
        if (delivery._transportWork) {
            return;
        }
        delivery.setTransportWorkNext(null);
        delivery.setTransportWorkPrev(this._transportWorkTail);
        if (this._transportWorkTail != null) {
            this._transportWorkTail.setTransportWorkNext(delivery);
        }
        this._transportWorkTail = delivery;
        if (this._transportWorkHead == null) {
            this._transportWorkHead = delivery;
        }
        delivery._transportWork = true;
        ++this._transportWorkSize;
    }

    void workUpdate(DeliveryImpl delivery) {
        if (delivery != null) {
            if (!delivery.isSettled() && (delivery.isReadable() || delivery.isWritable() || delivery.isUpdated())) {
                this.addWork(delivery);
            } else {
                this.removeWork(delivery);
            }
        }
    }

    @Override
    public Object getContext() {
        return this._context;
    }

    @Override
    public void setContext(Object context) {
        this._context = context;
    }

    @Override
    public void collect(Collector collector) {
        this._collector = (CollectorImpl)collector;
        this.put(Event.Type.CONNECTION_INIT, this);
        for (LinkNode<SessionImpl> ssn = this._sessionHead; ssn != null; ssn = ssn.getNext()) {
            this.put(Event.Type.SESSION_INIT, ssn.getValue());
        }
        for (LinkNode<LinkImpl> lnk = this._linkHead; lnk != null; lnk = lnk.getNext()) {
            this.put(Event.Type.LINK_INIT, lnk.getValue());
        }
    }

    EventImpl put(Event.Type type, Object context) {
        if (this._collector != null) {
            return this._collector.put(type, context);
        }
        return null;
    }

    @Override
    void localOpen() {
        this.put(Event.Type.CONNECTION_LOCAL_OPEN, this);
    }

    @Override
    void localClose() {
        this.put(Event.Type.CONNECTION_LOCAL_CLOSE, this);
    }

    @Override
    public Reactor getReactor() {
        return this._reactor;
    }

    public void setReactor(Reactor reactor) {
        this._reactor = reactor;
    }

    private static class WorkSequence
    implements Iterator<DeliveryImpl> {
        private DeliveryImpl _next;

        public WorkSequence(DeliveryImpl workHead) {
            this._next = workHead;
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DeliveryImpl next() {
            DeliveryImpl next = this._next;
            if (next != null) {
                this._next = next.getWorkNext();
            }
            return next;
        }
    }
}

