/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.glob;

import aQute.libg.glob.AntGlob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PathSet {
    private final List<Pattern> includes = new ArrayList<Pattern>();
    private final List<Pattern> excludes = new ArrayList<Pattern>();

    public PathSet() {
    }

    public PathSet(String ... includes) {
        this.include(includes);
    }

    public PathSet includes(List<String> includes) {
        if (includes != null) {
            PathSet.addPatterns(includes.stream(), this.includes);
        }
        return this;
    }

    public PathSet include(String ... includes) {
        if (includes != null) {
            PathSet.addPatterns(Arrays.stream(includes), this.includes);
        }
        return this;
    }

    public PathSet exclude(String ... excludes) {
        if (excludes != null) {
            PathSet.addPatterns(Arrays.stream(excludes), this.excludes);
        }
        return this;
    }

    public PathSet excludes(List<String> excludes) {
        if (excludes != null) {
            PathSet.addPatterns(excludes.stream(), this.excludes);
        }
        return this;
    }

    private static List<Pattern> addPatterns(Stream<String> globs, List<Pattern> patterns) {
        globs.filter(Objects::nonNull).map(AntGlob::toPattern).forEachOrdered(patterns::add);
        return patterns;
    }

    public List<String> paths(Collection<String> paths, String ... defaultIncludes) {
        return PathSet.paths(paths, this.matches(defaultIncludes));
    }

    public List<String> paths(Collection<String> paths, List<String> defaultIncludes) {
        return PathSet.paths(paths, this.matches(defaultIncludes));
    }

    public List<String> paths(Collection<String> paths) {
        return PathSet.paths(paths, this.matches());
    }

    private static List<String> paths(Collection<String> paths, Predicate<String> matches) {
        return paths.stream().filter(matches).collect(Collectors.toList());
    }

    public Predicate<String> matches(String ... defaultIncludes) {
        if (this.includes.isEmpty() && defaultIncludes != null && defaultIncludes.length > 0) {
            return PathSet.matches(PathSet.addPatterns(Arrays.stream(defaultIncludes), new ArrayList<Pattern>()), this.excludes);
        }
        return PathSet.matches(this.includes, this.excludes);
    }

    public Predicate<String> matches(List<String> defaultIncludes) {
        if (this.includes.isEmpty() && defaultIncludes != null && !defaultIncludes.isEmpty()) {
            return PathSet.matches(PathSet.addPatterns(defaultIncludes.stream(), new ArrayList<Pattern>()), this.excludes);
        }
        return PathSet.matches(this.includes, this.excludes);
    }

    public Predicate<String> matches() {
        return PathSet.matches(this.includes, this.excludes);
    }

    private static Predicate<String> matches(List<Pattern> includePatterns, List<Pattern> excludePatterns) {
        if (includePatterns.isEmpty()) {
            return path -> false;
        }
        if (excludePatterns.isEmpty()) {
            if (includePatterns.size() == 1) {
                Pattern include = includePatterns.get(0);
                return path -> include.matcher((CharSequence)path).matches();
            }
            ArrayList<Pattern> includes = new ArrayList<Pattern>(includePatterns);
            return path -> includes.stream().anyMatch(include -> include.matcher((CharSequence)path).matches());
        }
        ArrayList<Pattern> includes = new ArrayList<Pattern>(includePatterns);
        ArrayList<Pattern> excludes = new ArrayList<Pattern>(excludePatterns);
        return path -> includes.stream().anyMatch(include -> include.matcher((CharSequence)path).matches()) && excludes.stream().noneMatch(exclude -> exclude.matcher((CharSequence)path).matches());
    }
}

