/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.io;

import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer bb;

    public ByteBufferInputStream(ByteBuffer buffer) {
        buffer.mark();
        this.bb = buffer;
    }

    public ByteBufferInputStream(byte[] b, int off, int len) {
        this(ByteBuffer.wrap(b, off, len));
    }

    public ByteBufferInputStream(byte[] b) {
        this(b, 0, b.length);
    }

    @Override
    public int read() {
        if (!this.bb.hasRemaining()) {
            return -1;
        }
        return Byte.toUnsignedInt(this.bb.get());
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int remaining = this.bb.remaining();
        if (remaining <= 0) {
            return -1;
        }
        int length = Math.min(len, remaining);
        this.bb.get(b, off, length);
        return length;
    }

    @Override
    public long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        int skipped = Math.min((int)n, this.bb.remaining());
        this.bb.position(this.bb.position() + skipped);
        return skipped;
    }

    @Override
    public int available() {
        return this.bb.remaining();
    }

    @Override
    public void close() {
        this.bb.position(this.bb.limit());
    }

    @Override
    public void mark(int readlimit) {
        this.bb.mark();
    }

    @Override
    public void reset() {
        this.bb.reset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    ByteBuffer buffer() {
        return this.bb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[pos=");
        sb.append(this.bb.position());
        sb.append(" lim=");
        sb.append(this.bb.limit());
        sb.append(" cap=");
        sb.append(this.bb.capacity());
        sb.append("]");
        return sb.toString();
    }
}

