/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.core.internal;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

public class CircularBuffer {
    private final AtomicInteger currentIdx = new AtomicInteger(0);
    private final AtomicReferenceArray<PaxLoggingEvent> buffer;

    public CircularBuffer(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.buffer = new AtomicReferenceArray(size);
    }

    public int maxSize() {
        return this.buffer.length();
    }

    public void add(PaxLoggingEvent element) {
        if (null == element) {
            throw new NullPointerException("Attempted to add null object to buffer");
        }
        this.doAdd(element);
    }

    public List<PaxLoggingEvent> getElements(int requestedCount) {
        int max = Math.min(this.buffer.length(), requestedCount);
        int current = this.currentIdx.get() % this.buffer.length();
        return this.collectEvents(max, idx -> this.buffer.get((current + idx) % this.buffer.length()));
    }

    private List<PaxLoggingEvent> collectEvents(int max, IntFunction<PaxLoggingEvent> mapper) {
        return IntStream.range(0, max).mapToObj(mapper).filter(Objects::nonNull).sorted(Comparator.comparing(PaxLoggingEvent::getTimeStamp)).collect(Collectors.toList());
    }

    private void doAdd(PaxLoggingEvent element) {
        int idx = this.currentIdx.getAndUpdate(value -> {
            int newValue = value + 1;
            if (newValue >= this.buffer.length()) {
                return 0;
            }
            return newValue;
        }) % this.buffer.length();
        this.buffer.set(idx, element);
    }
}

