/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ntp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ntp.NtpV3Packet;
import org.apache.commons.net.ntp.TimeStamp;

public class TimeInfo {
    private final NtpV3Packet message;
    private List<String> comments;
    private Long delay;
    private Long offset;
    private final long returnTime;
    private boolean detailsComputed;

    public TimeInfo(NtpV3Packet message, long returnTime) {
        this(message, returnTime, null, true);
    }

    public TimeInfo(NtpV3Packet message, long returnTime, List<String> comments) {
        this(message, returnTime, comments, true);
    }

    public TimeInfo(NtpV3Packet msgPacket, long returnTime, boolean doComputeDetails) {
        this(msgPacket, returnTime, null, doComputeDetails);
    }

    public TimeInfo(NtpV3Packet message, long returnTime, List<String> comments, boolean doComputeDetails) {
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        this.returnTime = returnTime;
        this.message = message;
        this.comments = comments;
        if (doComputeDetails) {
            this.computeDetails();
        }
    }

    public void addComment(String comment) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.add(comment);
    }

    public void computeDetails() {
        if (this.detailsComputed) {
            return;
        }
        this.detailsComputed = true;
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        TimeStamp origNtpTime = this.message.getOriginateTimeStamp();
        long origTime = origNtpTime.getTime();
        TimeStamp rcvNtpTime = this.message.getReceiveTimeStamp();
        long rcvTime = rcvNtpTime.getTime();
        TimeStamp xmitNtpTime = this.message.getTransmitTimeStamp();
        long xmitTime = xmitNtpTime.getTime();
        if (origNtpTime.ntpValue() == 0L) {
            if (xmitNtpTime.ntpValue() != 0L) {
                this.offset = xmitTime - this.returnTime;
                this.comments.add("Error: zero orig time -- cannot compute delay");
            } else {
                this.comments.add("Error: zero orig time -- cannot compute delay/offset");
            }
        } else if (rcvNtpTime.ntpValue() == 0L || xmitNtpTime.ntpValue() == 0L) {
            this.comments.add("Warning: zero rcvNtpTime or xmitNtpTime");
            if (origTime > this.returnTime) {
                this.comments.add("Error: OrigTime > DestRcvTime");
            } else {
                this.delay = this.returnTime - origTime;
            }
            if (rcvNtpTime.ntpValue() != 0L) {
                this.offset = rcvTime - origTime;
            } else if (xmitNtpTime.ntpValue() != 0L) {
                this.offset = xmitTime - this.returnTime;
            }
        } else {
            long delayValue = this.returnTime - origTime;
            if (xmitTime < rcvTime) {
                this.comments.add("Error: xmitTime < rcvTime");
            } else {
                long delta = xmitTime - rcvTime;
                if (delta <= delayValue) {
                    delayValue -= delta;
                } else if (delta - delayValue == 1L) {
                    if (delayValue != 0L) {
                        this.comments.add("Info: processing time > total network time by 1 ms -> assume zero delay");
                        delayValue = 0L;
                    }
                } else {
                    this.comments.add("Warning: processing time > total network time");
                }
            }
            this.delay = delayValue;
            if (origTime > this.returnTime) {
                this.comments.add("Error: OrigTime > DestRcvTime");
            }
            this.offset = (rcvTime - origTime + (xmitTime - this.returnTime)) / 2L;
        }
    }

    public List<String> getComments() {
        return this.comments;
    }

    public Long getDelay() {
        return this.delay;
    }

    public Long getOffset() {
        return this.offset;
    }

    public NtpV3Packet getMessage() {
        return this.message;
    }

    public InetAddress getAddress() {
        DatagramPacket pkt = this.message.getDatagramPacket();
        return pkt == null ? null : pkt.getAddress();
    }

    public long getReturnTime() {
        return this.returnTime;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TimeInfo other = (TimeInfo)obj;
        return this.returnTime == other.returnTime && this.message.equals(other.message);
    }

    public int hashCode() {
        int prime = 31;
        int result = (int)this.returnTime;
        result = 31 * result + this.message.hashCode();
        return result;
    }
}

