/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    COUNTERS("counters"),
    LOWER_BOUND("lower-bound"),
    STRONG_COUNTER("strong-counter"),
    UPPER_BOUND("upper-bound"),
    WEAK_COUNTER("weak-counter");

    private static final Map<String, Element> ELEMENTS;
    private final String name;

    private Element(String name) {
        this.name = name;
    }

    public static Element forName(String localName) {
        Element element = ELEMENTS.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>(8);
        for (Element element : Element.values()) {
            String name = element.name;
            if (name == null) continue;
            map.put(name, element);
        }
        ELEMENTS = map;
    }
}

