/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.context;

import io.hyperfoil.cli.commands.ServerCommand;
import io.hyperfoil.cli.context.HyperfoilCliContext;
import io.hyperfoil.impl.Util;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.aesh.command.CommandException;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.Executor;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationConfiguration;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.shell.Shell;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.readline.Prompt;
import org.aesh.readline.action.KeyAction;

public class HyperfoilCommandInvocation
implements CommandInvocation {
    private final CommandInvocation commandInvocation;
    private final HyperfoilCliContext context;

    protected HyperfoilCommandInvocation(HyperfoilCliContext context, CommandInvocation commandInvocation) {
        this.context = context;
        this.commandInvocation = commandInvocation;
    }

    public HyperfoilCliContext context() {
        return this.context;
    }

    public Shell getShell() {
        return this.commandInvocation.getShell();
    }

    public void setPrompt(Prompt prompt) {
        if (System.getenv("CLI_PROMPT") == null) {
            this.commandInvocation.setPrompt(prompt);
        }
    }

    public Prompt getPrompt() {
        return this.commandInvocation.getPrompt();
    }

    public String getHelpInfo(String commandName) {
        return this.commandInvocation.getHelpInfo(commandName);
    }

    public String getHelpInfo() {
        return this.commandInvocation.getHelpInfo();
    }

    public void stop() {
        this.context.stop();
        this.commandInvocation.stop();
    }

    public KeyAction input() throws InterruptedException {
        return this.commandInvocation.input();
    }

    public KeyAction input(long timeout, TimeUnit unit) throws InterruptedException {
        return this.commandInvocation.input(timeout, unit);
    }

    public String inputLine() throws InterruptedException {
        return this.commandInvocation.inputLine();
    }

    public String inputLine(Prompt prompt) throws InterruptedException {
        return this.commandInvocation.inputLine(prompt);
    }

    public void executeCommand(String input) throws CommandNotFoundException, CommandLineParserException, OptionValidatorException, CommandValidatorException, CommandException, InterruptedException, IOException {
        this.commandInvocation.executeCommand(input);
    }

    public void print(String msg, boolean paging) {
        this.commandInvocation.print(msg, paging);
    }

    public void println(String msg, boolean paging) {
        this.commandInvocation.println(msg, paging);
    }

    public Executor<? extends CommandInvocation> buildExecutor(String line) throws CommandNotFoundException, CommandLineParserException, OptionValidatorException, CommandValidatorException, IOException {
        return this.commandInvocation.buildExecutor(line);
    }

    public CommandInvocationConfiguration getConfiguration() {
        return this.commandInvocation.getConfiguration();
    }

    public void warn(String message) {
        this.println("\u001b[0;33mWARNING: " + message + "\u001b[0m");
    }

    public void error(String message) {
        this.println("\u001b[0;31mERROR: " + message + "\u001b[0m");
    }

    public void error(Throwable t) {
        this.error(Util.explainCauses((Throwable)t));
    }

    public void error(String message, Throwable t) {
        this.error(message + ": " + Util.explainCauses((Throwable)t));
    }

    public void printStackTrace(Throwable t) {
        this.print("\u001b[0;31m");
        this.printStackTrace(t, new HashSet<Throwable>());
        this.print("\u001b[0m");
    }

    private void printStackTrace(Throwable t, HashSet<Throwable> set) {
        if (!set.add(t)) {
            this.println("[CIRCULAR REFERENCE]");
            return;
        }
        for (StackTraceElement stackTraceElement : t.getStackTrace()) {
            this.println("\tat " + String.valueOf(stackTraceElement));
        }
        for (Serializable serializable : t.getSuppressed()) {
            this.println("SUPPRESSED: " + ((Throwable)serializable).getMessage());
            this.printStackTrace((Throwable)serializable, set);
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            this.println("CAUSED BY: " + cause.getMessage());
            this.printStackTrace(cause, set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSwitchable(String input) throws CommandException {
        this.context.setSwitchable(true);
        try {
            while (true) {
                try {
                    this.executeCommand(input);
                }
                catch (RuntimeException e) {
                    Throwable cause;
                    for (cause = e.getCause(); cause instanceof RuntimeException && cause != cause.getCause() && !(cause instanceof ServerCommand.SwitchCommandException); cause = cause.getCause()) {
                    }
                    if (cause instanceof ServerCommand.SwitchCommandException) {
                        input = ((ServerCommand.SwitchCommandException)cause).newCommand;
                        continue;
                    }
                    this.error(e);
                    throw new CommandException((Throwable)e);
                }
                catch (Exception e) {
                    this.error(e);
                    throw new CommandException((Throwable)e);
                }
                break;
            }
        }
        finally {
            this.context.setSwitchable(false);
        }
    }
}

