/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.api.processor.RawBytesHandler;
import io.hyperfoil.api.statistics.StatisticsSummary;
import io.hyperfoil.cli.commands.BaseStandaloneCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClient;
import io.hyperfoil.controller.Client;
import io.hyperfoil.controller.HistogramConverter;
import io.hyperfoil.controller.model.Histogram;
import io.hyperfoil.controller.model.RequestStatisticsResponse;
import io.hyperfoil.controller.model.RequestStats;
import io.hyperfoil.core.handlers.TransferSizeRecorder;
import io.hyperfoil.function.SerializableBiConsumer;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.config.HttpPluginBuilder;
import io.hyperfoil.http.config.Protocol;
import io.hyperfoil.http.statistics.HttpStats;
import io.hyperfoil.http.steps.HttpStepCatalog;
import io.hyperfoil.impl.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.HistogramIterationValue;
import org.aesh.command.Command;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionGroup;
import org.aesh.command.option.OptionList;
import org.aesh.terminal.utils.ANSI;

public abstract class WrkAbstract
extends BaseStandaloneCommand {

    public abstract class AbstractWrkCommand
    implements Command<HyperfoilCommandInvocation> {
        @Option(shortName=99, description="Total number of HTTP connections to keep open", defaultValue={"10"})
        int connections;
        @Option(shortName=100, description="Duration of the test, e.g. 2s, 2m, 2h", defaultValue={"10s"})
        String duration;
        @Option(shortName=116, description="Total number of threads to use.", defaultValue={"2"})
        int threads;
        @Option(shortName=115, description="!!!NOT SUPPORTED: LuaJIT script")
        String script;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        boolean help;
        @OptionList(shortName=72, name="header", description="HTTP header to add to request, e.g. \"User-Agent: wrk\"")
        List<String> headers;
        @Option(description="Print detailed latency statistics", hasValue=false)
        boolean latency;
        @Option(description="Record a timeout if a response is not received within this amount of time.", defaultValue={"60s"})
        String timeout;
        @OptionGroup(shortName=65, description="Inline definition of agent executing the test. By default assuming non-clustered mode.")
        Map<String, String> agent;
        @Option(name="enable-http2", description="HTTP2 is not supported in wrk/wrk2: you can enable that for Hyperfoil.", defaultValue={"false"})
        boolean enableHttp2;
        @Option(name="use-http-cache", description="By default the HTTP cache is disabled, providing this option you can enable it.", hasValue=false)
        boolean useHttpCache;
        @Argument(description="URL that should be accessed", required=true)
        String url;
        String path;
        String[][] parsedHeaders;
        boolean started = false;
        boolean initialized = false;

        public CommandResult execute(HyperfoilCommandInvocation invocation) {
            URI uri;
            if (this.help) {
                invocation.println(invocation.getHelpInfo(WrkAbstract.this.getCommandName()));
                return CommandResult.SUCCESS;
            }
            if (this.script != null) {
                invocation.println("Scripting is not supported at this moment.");
            }
            if (!this.url.startsWith("http://") && !this.url.startsWith("https://")) {
                this.url = "http://" + this.url;
            }
            try {
                uri = new URI(this.url);
            }
            catch (URISyntaxException e) {
                invocation.println("Failed to parse URL: " + e.getMessage());
                return CommandResult.FAILURE;
            }
            this.path = uri.getPath();
            if (this.path == null || this.path.isEmpty()) {
                this.path = "/";
            }
            if (uri.getQuery() != null) {
                this.path = this.path + "?" + uri.getQuery();
            }
            if (uri.getFragment() != null) {
                this.path = this.path + "#" + uri.getFragment();
            }
            if (this.headers != null) {
                this.parsedHeaders = new String[this.headers.size()][];
                for (int i = 0; i < this.headers.size(); ++i) {
                    String h = this.headers.get(i);
                    int colonIndex = h.indexOf(58);
                    if (colonIndex < 0) {
                        invocation.println(String.format("Cannot parse header '%s', ignoring.", h));
                        continue;
                    }
                    String header = h.substring(0, colonIndex).trim();
                    String value = h.substring(colonIndex + 1).trim();
                    this.parsedHeaders[i] = new String[]{header, value};
                }
            } else {
                this.parsedHeaders = null;
            }
            Protocol protocol = Protocol.fromScheme((String)uri.getScheme());
            BenchmarkBuilder builder = ((HttpPluginBuilder)BenchmarkBuilder.builder().name(WrkAbstract.this.getCommandName()).addPlugin(HttpPluginBuilder::new)).ergonomics().repeatCookies(false).userAgentFromSession(false).endErgonomics().http().protocol(protocol).host(uri.getHost()).port(protocol.portOrDefault(uri.getPort())).allowHttp2(this.enableHttp2).sharedConnections(this.connections).useHttpCache(this.useHttpCache).endHttp().endPlugin().threads(this.threads);
            if (this.agent != null) {
                for (Map.Entry<String, String> agent : this.agent.entrySet()) {
                    Map<String, String> properties = Stream.of(agent.getValue().split(",")).map(property -> {
                        String[] pair = property.split("=", 2);
                        if (pair.length != 2) {
                            throw new IllegalArgumentException("Cannot parse " + property + " as a property: Agent should be formatted as -AagentName=key1=value1,key2=value2...");
                        }
                        return pair;
                    }).collect(Collectors.toMap(keyValue -> keyValue[0], keyValue -> keyValue[1]));
                    builder.addAgent(agent.getKey(), null, properties);
                }
            }
            this.addPhase(builder, PhaseType.calibration, "6s");
            this.addPhase(builder, PhaseType.test, this.duration).startAfterStrict(PhaseType.calibration.name()).maxDuration(Util.parseToMillis((String)this.duration));
            RestClient client = invocation.context().client();
            if (client == null) {
                invocation.println("You're not connected to a controller; either " + ANSI.BOLD + "connect\u001b[0;22m to running instance or use " + ANSI.BOLD + "start-local\u001b[0;22m to start a controller in this VM");
                return CommandResult.FAILURE;
            }
            Client.BenchmarkRef benchmark = client.register(builder.build(), null);
            invocation.context().setServerBenchmark(benchmark);
            Client.RunRef run = benchmark.start(null, Collections.emptyMap());
            invocation.context().setServerRun(run);
            boolean result = this.awaitBenchmarkResult(run, invocation);
            if (result) {
                if (!this.started && !run.get().errors.isEmpty()) {
                    invocation.println("ERROR: " + String.join((CharSequence)", ", run.get().errors));
                    return CommandResult.FAILURE;
                }
                RequestStatisticsResponse total = run.statsTotal();
                RequestStats testStats = total.statistics.stream().filter(rs -> PhaseType.test.name().equals(rs.phase)).findFirst().orElseThrow(() -> new IllegalStateException("Error running command: Missing Statistics"));
                AbstractHistogram histogram = HistogramConverter.convert((Histogram)run.histogram(testStats.phase, testStats.stepId, testStats.metric));
                List series = run.series(testStats.phase, testStats.stepId, testStats.metric);
                this.printStats(testStats.summary, histogram, series, invocation);
                return CommandResult.SUCCESS;
            }
            return CommandResult.FAILURE;
        }

        private boolean awaitBenchmarkResult(Client.RunRef run, HyperfoilCommandInvocation invocation) {
            while (true) {
                RequestStatisticsResponse recent = run.statsRecent();
                if ("TERMINATED".equals(recent.status)) break;
                if ("INITIALIZING".equals(recent.status) && !this.initialized) {
                    this.initialized = true;
                } else if ("RUNNING".equals(recent.status) && !this.started) {
                    invocation.println("Running " + this.duration + " test @ " + this.url);
                    invocation.println("  " + this.threads + " threads and " + this.connections + " connections");
                    this.started = true;
                    this.initialized = true;
                }
                invocation.getShell().write(ANSI.CURSOR_START);
                invocation.getShell().write(ANSI.ERASE_WHOLE_LINE);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    invocation.println("Interrupt received, trying to abort run...");
                    run.kill();
                    return false;
                }
            }
            return true;
        }

        protected abstract PhaseBuilder<?> phaseConfig(PhaseBuilder.Catalog var1, PhaseType var2, long var3);

        private PhaseBuilder<?> addPhase(BenchmarkBuilder benchmarkBuilder, PhaseType phaseType, String durationStr) {
            String[][] parsedHeaders = this.parsedHeaders;
            long duration = Util.parseToMillis((String)durationStr);
            ScenarioBuilder scenarioBuilder = this.phaseConfig(benchmarkBuilder.addPhase(phaseType.name()), phaseType, duration).duration(duration).maxDuration(duration + Util.parseToMillis((String)this.timeout)).scenario();
            scenarioBuilder.maxRequests(1);
            scenarioBuilder.maxSequences(1);
            return ((HttpStepCatalog)scenarioBuilder.initialSequence("request").step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path(this.path).headerAppender((SerializableBiConsumer & Serializable)(session, request) -> {
                if (parsedHeaders != null) {
                    for (String[] header : parsedHeaders) {
                        request.putHeader((CharSequence)header[0], (CharSequence)header[1]);
                    }
                }
            }).timeout(this.timeout).handler().rawBytes((RawBytesHandler)new TransferSizeRecorder("transfer")).endHandler().endStep().endSequence().endScenario();
        }

        private void printStats(StatisticsSummary stats, AbstractHistogram histogram, List<StatisticsSummary> series, final CommandInvocation invocation) {
            TransferSizeRecorder.Stats transferStats = (TransferSizeRecorder.Stats)stats.extensions.get("transfer");
            HttpStats httpStats = HttpStats.get((StatisticsSummary)stats);
            double durationSeconds = (double)(stats.endTime - stats.startTime) / 1000.0;
            invocation.println(String.format("  Thread Stats%6s%11s%8s%12s", "Avg", "Stdev", "Max", "+/- Stdev"));
            invocation.println("    Latency   " + Util.prettyPrintNanos((long)stats.meanResponseTime, (String)"6", (boolean)false) + Util.prettyPrintNanos((long)((long)histogram.getStdDeviation()), (String)"8", (boolean)false) + Util.prettyPrintNanos((long)stats.maxResponseTime, (String)"7", (boolean)false) + String.format("%8.2f%%", this.statsWithinStdev(stats, histogram)));
            DoubleSummaryStatistics requestsStats = series.stream().mapToDouble(s -> s.requestCount).summaryStatistics();
            double requestsStdDev = !series.isEmpty() ? Math.sqrt(series.stream().mapToDouble(s -> Math.pow((double)s.requestCount - requestsStats.getAverage(), 2.0)).sum() / (double)series.size()) : 0.0;
            invocation.println("    Req/Sec   " + String.format("%6.2f  ", requestsStats.getAverage()) + String.format("%8.2f  ", requestsStdDev) + String.format("%7.2f  ", requestsStats.getMax()) + String.format("%8.2f", this.statsWithinStdev(requestsStats, requestsStdDev, series.stream().mapToInt(s -> s.requestCount), series.size())));
            if (this.latency) {
                invocation.println("  Latency Distribution");
                for (double percentile : Arrays.asList(50.0, 75.0, 90.0, 99.0, 99.9, 99.99, 99.999, 100.0)) {
                    invocation.println(String.format("    %7.3f%%", percentile) + " " + Util.prettyPrintNanos((long)histogram.getValueAtPercentile(percentile), (String)"9", (boolean)false));
                }
                invocation.println("");
                invocation.println("  Detailed Percentile Spectrum");
                histogram.outputPercentileDistribution(new PrintStream(new OutputStream(this){

                    @Override
                    public void write(int b) throws IOException {
                        invocation.print(String.valueOf((char)b));
                    }
                }), 5, Double.valueOf(1000000.0));
                invocation.println("----------------------------------------------------------");
            }
            invocation.println("  " + stats.requestCount + " requests in " + durationSeconds + "s, " + Util.prettyPrintData((double)(transferStats.sent + transferStats.received)) + " read");
            invocation.println("Requests/sec: " + String.format("%.02f", (double)stats.requestCount / durationSeconds));
            invocation.println("Transfer/sec: " + Util.prettyPrintData((double)((double)(transferStats.sent + transferStats.received) / durationSeconds)));
            if (stats.connectionErrors + stats.requestTimeouts + stats.internalErrors > 0) {
                invocation.println("Socket errors: connectionErrors " + stats.connectionErrors + ", requestTimeouts " + stats.requestTimeouts);
            }
            if (httpStats.status_4xx + httpStats.status_5xx + httpStats.status_other > 0) {
                invocation.println("Non-2xx or 3xx responses: " + (httpStats.status_4xx + httpStats.status_5xx + httpStats.status_other));
            }
        }

        private double statsWithinStdev(DoubleSummaryStatistics stats, double stdDev, IntStream stream, int count) {
            double lower = stats.getAverage() - stdDev;
            double upper = stats.getAverage() + stdDev;
            return 100.0 * (double)stream.filter(reqs -> (double)reqs >= lower && (double)reqs <= upper).count() / (double)count;
        }

        private double statsWithinStdev(StatisticsSummary stats, AbstractHistogram histogram) {
            double stdDev = histogram.getStdDeviation();
            double lower = (double)stats.meanResponseTime - stdDev;
            double upper = (double)stats.meanResponseTime + stdDev;
            long sum = 0L;
            for (HistogramIterationValue value : histogram.allValues()) {
                if (!((double)value.getValueIteratedFrom() >= lower) || !((double)value.getValueIteratedTo() <= upper)) continue;
                sum += value.getCountAddedInThisIterationStep();
            }
            return 100.0 * (double)sum / (double)stats.requestCount;
        }

        public static enum PhaseType {
            calibration,
            test;

        }
    }
}

