/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.cli.commands.WrkAbstract;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;

public class Wrk2
extends WrkAbstract {
    private static final String CMD = "wrk2";

    public static void main(String[] args) {
        Wrk2 wrk = new Wrk2();
        wrk.exec(args);
    }

    @Override
    protected String getCommandName() {
        return CMD;
    }

    @Override
    protected Class<? extends Command<HyperfoilCommandInvocation>> getCommand() {
        return Wrk2Command.class;
    }

    @CommandDefinition(name="wrk2", description="Runs a workload simulation against one endpoint using the same vm")
    public class Wrk2Command
    extends WrkAbstract.AbstractWrkCommand {
        @Option(shortName=82, description="Work rate (throughput)", required=true)
        int rate;

        public Wrk2Command(Wrk2 this$0) {
            super(this$0);
        }

        @Override
        protected PhaseBuilder<?> phaseConfig(PhaseBuilder.Catalog catalog, WrkAbstract.AbstractWrkCommand.PhaseType phaseType, long durationMs) {
            int durationSeconds = (int)Math.ceil(durationMs / 1000L);
            int maxSessions = switch (phaseType) {
                default -> throw new MatchException(null, null);
                case WrkAbstract.AbstractWrkCommand.PhaseType.calibration -> this.rate * durationSeconds;
                case WrkAbstract.AbstractWrkCommand.PhaseType.test -> this.rate * 15;
            };
            return ((PhaseBuilder.ConstantRate)catalog.constantRate(this.rate).variance(false)).maxSessions(maxSessions);
        }
    }
}

