/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.BaseRunIdCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.controller.Client;
import io.hyperfoil.controller.model.RequestStatisticsResponse;
import io.hyperfoil.controller.model.Run;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.terminal.utils.ANSI;

@CommandDefinition(name="wait", description="Wait for a specific run termination.")
public class Wait
extends BaseRunIdCommand {
    private boolean started = false;
    private boolean terminated = false;
    private boolean persisted = false;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException, InterruptedException {
        Client.RunRef runRef = this.getRunRef(invocation);
        Run run = this.getRun(invocation, runRef);
        invocation.println("Monitoring run " + runRef.id() + ", benchmark " + runRef.benchmark().name());
        if (run.description != null) {
            invocation.println(run.description);
        }
        while (true) {
            RequestStatisticsResponse recent = runRef.statsRecent();
            if (!this.started && "RUNNING".equals(recent.status)) {
                this.started = true;
                run = runRef.get();
                invocation.println("Started:    " + DATE_FORMATTER.format(run.started));
            }
            if (!this.terminated && "TERMINATED".equals(recent.status)) {
                this.terminated = true;
                run = runRef.get();
                invocation.println("Terminated: " + DATE_FORMATTER.format(run.terminated));
                if (!run.errors.isEmpty()) {
                    invocation.println("\u001b[0;31m" + ANSI.BOLD + "Errors:\u001b[0m");
                    for (String error : run.errors) {
                        invocation.println(error);
                    }
                }
                invocation.context().notifyRunCompleted(run);
            }
            if (this.terminated && !this.persisted) {
                run = runRef.get();
                if (run.persisted) {
                    this.persisted = true;
                    invocation.println("Run statistics persisted in the local filesystem");
                    return CommandResult.SUCCESS;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                invocation.error(e);
                throw new CommandException("Cannot monitor run " + runRef.id(), (Throwable)e);
            }
        }
    }
}

