/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkSource;
import io.hyperfoil.cli.CliUtil;
import io.hyperfoil.cli.commands.BaseUploadCommand;
import io.hyperfoil.cli.context.HyperfoilCliContext;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import io.hyperfoil.core.impl.LocalBenchmarkData;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.stream.Collectors;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Argument;

@CommandDefinition(name="upload", description="Uploads benchmark definition to Hyperfoil Controller server")
public class Upload
extends BaseUploadCommand {
    @Argument(description="YAML benchmark definition file", required=true, completer=FileOptionCompleter.class)
    String benchmarkPath;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        this.ensureConnection(invocation);
        if (this.benchmarkPath != null && (this.benchmarkPath.startsWith("http://") || this.benchmarkPath.startsWith("https://"))) {
            LocalBenchmarkData extraData = this.loadExtras(invocation, null);
            if (extraData == null) {
                return CommandResult.FAILURE;
            }
            BenchmarkSource source = this.loadFromUrl(invocation, this.benchmarkPath, extraData.files());
            if (source == null) {
                return CommandResult.FAILURE;
            }
            Client.BenchmarkRef benchmarkRef = invocation.context().client().register(source.yaml, source.data.files(), null, null);
            invocation.context().setServerBenchmark(benchmarkRef);
            invocation.println("... done.");
            return CommandResult.SUCCESS;
        }
        return this.uploadFromFile(invocation);
    }

    private LocalBenchmarkData loadExtras(HyperfoilCommandInvocation invocation, Path o) {
        LocalBenchmarkData extraData = new LocalBenchmarkData(o);
        if (this.extraFiles != null) {
            for (String extraFile : this.extraFiles) {
                try {
                    InputStream ignored = extraData.readFile(extraFile);
                    if (ignored == null) continue;
                    ignored.close();
                }
                catch (IOException e) {
                    invocation.error("Cannot read file " + extraFile, e);
                    return null;
                }
            }
        }
        return extraData;
    }

    private CommandResult uploadFromFile(HyperfoilCommandInvocation invocation) throws CommandException {
        String benchmarkYaml;
        String sanitizedPathStr = CliUtil.sanitize(this.benchmarkPath);
        Path sanitizedPath = Paths.get(sanitizedPathStr, new String[0]);
        try {
            benchmarkYaml = Files.readString(sanitizedPath);
        }
        catch (IOException e) {
            this.logError(invocation, e);
            throw new CommandException("Failed to load the benchmark", (Throwable)e);
        }
        LocalBenchmarkData data = this.loadExtras(invocation, sanitizedPath.toAbsolutePath());
        if (data == null) {
            return CommandResult.FAILURE;
        }
        try {
            BenchmarkSource source = this.loadBenchmarkSource(invocation, benchmarkYaml, (BenchmarkData)data);
            Path benchmarkDir = sanitizedPath.toAbsolutePath().getParent();
            Map<String, Path> extraFiles = source.data.files().keySet().stream().collect(Collectors.toMap(file -> file, file -> {
                Path path = Paths.get(file, new String[0]);
                return path.isAbsolute() ? path : benchmarkDir.resolve((String)file);
            }));
            HyperfoilCliContext ctx = invocation.context();
            Client.BenchmarkRef benchmarkRef = ctx.client().register(sanitizedPath.toAbsolutePath(), extraFiles, null, null);
            ctx.setServerBenchmark(benchmarkRef);
            invocation.println("... done.");
            return CommandResult.SUCCESS;
        }
        catch (RestClientException e) {
            invocation.error(e);
            throw new CommandException("Failed to upload the benchmark.", (Throwable)e);
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            this.logError(invocation, e);
            throw new CommandException("Unknown error.", (Throwable)e);
        }
    }
}

