/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.api.statistics.StatisticsSummary;
import io.hyperfoil.api.statistics.StatsExtension;
import io.hyperfoil.cli.Table;
import io.hyperfoil.cli.commands.BaseRunIdCommand;
import io.hyperfoil.cli.commands.HyperfoilOptionCompleter;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import io.hyperfoil.controller.model.RequestStatisticsResponse;
import io.hyperfoil.controller.model.RequestStats;
import io.hyperfoil.http.statistics.HttpStats;
import java.util.Map;
import java.util.stream.Stream;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;

@CommandDefinition(name="stats", description="Show run statistics")
public class Stats
extends BaseRunIdCommand {
    private static final Table<RequestStats> REQUEST_STATS_TABLE = new Table().idColumns(2).rowPrefix(r -> r.failedSLAs.isEmpty() ? null : "\u001b[0;31m").rowSuffix(r -> "\u001b[0m").column("PHASE", r -> r.phase).column("METRIC", r -> r.metric).column("THROUGHPUT", Stats::throughput, Table.Align.RIGHT).columnInt("REQUESTS", r -> r.summary.requestCount).columnNanos("MEAN", r -> r.summary.meanResponseTime).columnNanos("STD_DEV", r -> r.summary.stdDevResponseTime).columnNanos("MAX", r -> r.summary.maxResponseTime).columnNanos("p50", r -> (Long)r.summary.percentileResponseTime.get(50.0)).columnNanos("p90", r -> (Long)r.summary.percentileResponseTime.get(90.0)).columnNanos("p99", r -> (Long)r.summary.percentileResponseTime.get(99.0)).columnNanos("p99.9", r -> (Long)r.summary.percentileResponseTime.get(99.9)).columnNanos("p99.99", r -> (Long)r.summary.percentileResponseTime.get(99.99)).columnInt("TIMEOUTS", r -> r.summary.requestTimeouts).columnInt("ERRORS", r -> r.summary.connectionErrors + r.summary.internalErrors).columnNanos("BLOCKED", r -> r.summary.blockedTime);
    private static final String[] DIRECT_EXTENSIONS = new String[]{"http"};
    @Option(shortName=116, description="Show total stats instead of recent.", hasValue=false)
    private boolean total;
    @Option(shortName=101, description="Show extensions for given key. Use 'all' or '*' to show all extensions not shown by default, or comma-separated list.", completer=ExtensionsCompleter.class)
    private String extensions;
    @Option(shortName=119, description="Include statistics from warmup phases.", hasValue=false)
    private boolean warmup;

    private static String throughput(RequestStats r) {
        if (r.summary.endTime <= r.summary.startTime) {
            return "<none>";
        }
        double rate = 1000.0 * (double)r.summary.responseCount / (double)(r.summary.endTime - r.summary.startTime);
        if (rate < 10000.0) {
            return String.format("%.2f req/s", rate);
        }
        if (rate < 1.0E7) {
            return String.format("%.2fk req/s", rate / 1000.0);
        }
        return String.format("%.2fM req/s", rate / 1000000.0);
    }

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        Client.RunRef runRef = this.getRunRef(invocation);
        boolean terminated = false;
        int prevLines = -2;
        do {
            RequestStatisticsResponse stats;
            try {
                stats = this.total ? runRef.statsTotal() : runRef.statsRecent();
            }
            catch (RestClientException e) {
                if (e.getCause() instanceof InterruptedException) {
                    this.clearLines(invocation, 1);
                    invocation.println("");
                    break;
                }
                invocation.error(e);
                throw new CommandException("Cannot fetch stats for run " + runRef.id(), (Throwable)e);
            }
            if ("TERMINATED".equals(stats.status)) {
                stats = runRef.statsTotal();
                terminated = true;
            }
            this.clearLines(invocation, prevLines + 2);
            if (this.total || terminated) {
                invocation.println("Total stats from run " + runRef.id());
            } else {
                invocation.println("Recent stats from run " + runRef.id());
            }
            prevLines = this.extensions == null || this.extensions.isEmpty() ? this.showGeneralStats(invocation, stats) : this.showExtensions(invocation, stats);
        } while (!terminated && !this.interruptibleDelay(invocation));
        return CommandResult.SUCCESS;
    }

    private int showGeneralStats(HyperfoilCommandInvocation invocation, RequestStatisticsResponse stats) {
        int prevLines = 0;
        CharSequence[] extensions = (String[])Stats.extensions(stats).toArray(String[]::new);
        if (extensions.length > 0) {
            invocation.print("Extensions (use -e to show): ");
            invocation.println(String.join((CharSequence)", ", extensions));
            ++prevLines;
        }
        Table<RequestStats> table = new Table<RequestStats>(REQUEST_STATS_TABLE);
        this.addDirectExtensions(stats, table);
        prevLines += table.print(invocation, this.stream(stats));
        for (RequestStats rs : stats.statistics) {
            if (rs.isWarmup && !this.warmup) continue;
            for (String msg : rs.failedSLAs) {
                invocation.println(String.format("%s/%s: %s", rs.phase, rs.metric == null ? "*" : rs.metric, msg));
                ++prevLines;
            }
        }
        return prevLines;
    }

    private Stream<RequestStats> stream(RequestStatisticsResponse stats) {
        Stream<RequestStats> stream = stats.statistics.stream();
        if (!this.warmup) {
            stream = stream.filter(rs -> !rs.isWarmup);
        }
        return stream;
    }

    private int showExtensions(HyperfoilCommandInvocation invocation, RequestStatisticsResponse stats) {
        Table<RequestStats> table = new Table().idColumns(2);
        table.column("PHASE", r -> r.phase).column("METRIC", r -> r.metric);
        if (this.extensions.equalsIgnoreCase("all") || this.extensions.equals("*")) {
            Stats.extensions(stats).flatMap(ext -> this.stream(stats).flatMap(rs -> {
                StatsExtension extension = (StatsExtension)rs.summary.extensions.get(ext);
                return extension == null ? Stream.empty() : Stream.of(extension.headers()).map(h -> Map.entry(ext, h));
            })).distinct().forEach(extHeader -> table.column((String)extHeader.getKey() + "." + (String)extHeader.getValue(), rs -> ((StatsExtension)rs.summary.extensions.get(extHeader.getKey())).byHeader((String)extHeader.getValue()), Table.Align.RIGHT));
        } else if (!this.extensions.contains(",")) {
            this.stream(stats).flatMap(rs -> {
                StatsExtension extension = (StatsExtension)rs.summary.extensions.get(this.extensions);
                return extension == null ? Stream.empty() : Stream.of(extension.headers());
            }).distinct().forEach(header -> table.column((String)header, rs -> ((StatsExtension)rs.summary.extensions.get(this.extensions)).byHeader(header), Table.Align.RIGHT));
        } else {
            String[] exts = this.extensions.split(",");
            this.stream(stats).flatMap(rs -> Stream.of(exts).flatMap(ext -> {
                StatsExtension extension = (StatsExtension)rs.summary.extensions.get(ext);
                return extension == null ? Stream.empty() : Stream.of(extension.headers()).map(h -> Map.entry(ext, h));
            })).distinct().forEach(extHeader -> table.column((String)extHeader.getKey() + "." + (String)extHeader.getValue(), rs -> ((StatsExtension)rs.summary.extensions.get(extHeader.getKey())).byHeader((String)extHeader.getValue()), Table.Align.RIGHT));
        }
        return table.print(invocation, this.stream(stats));
    }

    private static Stream<String> extensions(RequestStatisticsResponse stats) {
        return stats.statistics.stream().flatMap(rs -> rs.summary.extensions.keySet().stream()).sorted().distinct().filter(ext -> Stream.of(DIRECT_EXTENSIONS).noneMatch(de -> de.equals(ext)));
    }

    private void addDirectExtensions(RequestStatisticsResponse stats, Table<RequestStats> table) {
        boolean hasHttp = this.stream(stats).anyMatch(rs -> rs.summary.extensions.containsKey("http"));
        if (hasHttp) {
            table.columnInt("2xx", r -> HttpStats.get((StatisticsSummary)r.summary).status_2xx).columnInt("3xx", r -> HttpStats.get((StatisticsSummary)r.summary).status_3xx).columnInt("4xx", r -> HttpStats.get((StatisticsSummary)r.summary).status_4xx).columnInt("5xx", r -> HttpStats.get((StatisticsSummary)r.summary).status_5xx).columnInt("CACHE", r -> HttpStats.get((StatisticsSummary)r.summary).cacheHits);
        }
    }

    public static class ExtensionsCompleter
    extends HyperfoilOptionCompleter {
        public ExtensionsCompleter() {
            super(context -> {
                if (context.serverRun() == null) {
                    return Stream.empty();
                }
                return Stream.concat(Stats.extensions(context.serverRun().statsTotal()), Stream.of("all"));
            });
        }
    }
}

