/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BenchmarkSource;
import io.hyperfoil.cli.CliUtil;
import io.hyperfoil.cli.commands.ParamsCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import io.hyperfoil.core.impl.ProvidedBenchmarkData;
import io.hyperfoil.core.parser.BenchmarkParser;
import io.hyperfoil.core.parser.ParserException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;

@CommandDefinition(name="run", description="Starts benchmark on Hyperfoil Controller server")
public class Run
extends ParamsCommand {
    @Option(shortName=100, description="Run description")
    String description;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        Map<String, String> currentParams;
        Client.BenchmarkRef benchmarkRef;
        block10: {
            this.setup(invocation);
            benchmarkRef = this.ensureBenchmark(invocation);
            currentParams = this.getParams(invocation);
            try {
                String yaml;
                Client.BenchmarkSource benchmarkSource = benchmarkRef.source();
                String string = yaml = benchmarkSource != null ? benchmarkSource.source : null;
                if (yaml == null) break block10;
                ProvidedBenchmarkData data = new ProvidedBenchmarkData();
                data.ignoredFiles.addAll(benchmarkSource.files);
                BenchmarkSource source = BenchmarkParser.instance().createSource(yaml, (BenchmarkData)data);
                List<String> missingParams = this.getMissingParams(source.paramsWithDefaults, currentParams);
                if (!this.readParams(invocation, missingParams, currentParams)) {
                    return CommandResult.FAILURE;
                }
                if (!source.isTemplate()) break block10;
                boolean firstMissing = true;
                while (true) {
                    try {
                        BenchmarkParser.instance().buildBenchmark(source, currentParams);
                        if (!data.files().isEmpty()) {
                            invocation.context().client().register(yaml, data.files(), benchmarkSource.version, benchmarkRef.name());
                        }
                    }
                    catch (BenchmarkData.MissingFileException e) {
                        if (!firstMissing) continue;
                        firstMissing = false;
                        invocation.println("This benchmark template is missing some files.");
                        if (this.onMissingFile(invocation, e.file, data)) continue;
                        return CommandResult.FAILURE;
                    }
                    break;
                }
            }
            catch (RestClientException e) {
                invocation.error("Failed to retrieve source for benchmark " + benchmarkRef.name(), e);
            }
            catch (BenchmarkDefinitionException | ParserException e) {
                invocation.error("Failed to parse retrieved source for benchmark " + benchmarkRef.name(), e);
                return CommandResult.FAILURE;
            }
        }
        invocation.context().setCurrentParams(currentParams);
        try {
            invocation.context().setServerRun(benchmarkRef.start(this.description, currentParams));
            invocation.println("Started run " + invocation.context().serverRun().id());
        }
        catch (RestClientException e) {
            invocation.error(e);
            throw new CommandException("Failed to start benchmark " + benchmarkRef.name(), (Throwable)e);
        }
        this.monitor(invocation);
        return CommandResult.SUCCESS;
    }

    protected void setup(HyperfoilCommandInvocation invocation) throws CommandException {
    }

    protected void monitor(HyperfoilCommandInvocation invocation) throws CommandException {
        invocation.executeSwitchable("status");
    }

    protected boolean onMissingFile(HyperfoilCommandInvocation invocation, String file, ProvidedBenchmarkData data) {
        try {
            Path path = CliUtil.getLocalFileForUpload(invocation, file);
            if (path != null) {
                data.files.put(file, Files.readAllBytes(path));
            } else {
                data.ignoredFiles.add(file);
            }
            return true;
        }
        catch (InterruptedException interruptedException) {
            invocation.warn("Cancelled, not running anything.");
            return false;
        }
        catch (IOException ioException) {
            invocation.error("Cannot load " + file, ioException);
            return false;
        }
    }
}

