/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.BaseRunIdCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;

@CommandDefinition(name="report", description="Generate HTML report")
public class Report
extends BaseRunIdCommand {
    @Option(shortName=115, description="Other file (in given run) to use as report input.")
    protected String source;
    @Option(shortName=100, description="Destination path to the HTML report", required=true, askIfNotSet=true)
    private String destination;
    @Option(shortName=121, description="Assume yes for all interactive questions.", hasValue=false)
    public boolean assumeYes;
    @Option(description="Do not open the HTML report automatically", hasValue=false)
    public boolean silent;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        Client.RunRef runRef = this.getRunRef(invocation);
        File destination = new File(this.destination);
        if (destination.exists()) {
            if (destination.isFile()) {
                if (!this.askForOverwrite(invocation, destination)) {
                    invocation.println("Cancelled. You can change destination file with '-d /path/to/report.html'");
                    return CommandResult.SUCCESS;
                }
            } else if (destination.isDirectory() && (destination = destination.toPath().resolve(runRef.id() + ".html").toFile()).exists()) {
                if (destination.isFile()) {
                    if (!this.askForOverwrite(invocation, destination)) {
                        invocation.println("Cancelled. You can change destination file with '-d /path/to/report.html'");
                        return CommandResult.SUCCESS;
                    }
                } else if (destination.isDirectory()) {
                    invocation.println("Both " + this.destination + " and " + String.valueOf(destination) + " are directories. Please use another path.");
                    return CommandResult.SUCCESS;
                }
            }
        }
        try {
            byte[] report = runRef.report(this.source);
            Files.write(destination.toPath(), report, new OpenOption[0]);
        }
        catch (RestClientException e) {
            invocation.error("Cannot fetch report for run " + runRef.id(), e);
            return CommandResult.FAILURE;
        }
        catch (IOException e) {
            invocation.error("Cannot write to '" + String.valueOf(destination) + "': ", e);
            return CommandResult.FAILURE;
        }
        invocation.println("Report written to " + String.valueOf(destination));
        if (!"true".equalsIgnoreCase(System.getenv("HYPERFOIL_CONTAINER")) && !this.silent) {
            this.openInBrowser("file://" + String.valueOf(destination));
        }
        return CommandResult.SUCCESS;
    }

    private boolean askForOverwrite(HyperfoilCommandInvocation invocation, File destination) {
        if (this.assumeYes) {
            return true;
        }
        invocation.print("File " + String.valueOf(destination) + " already exists, overwrite? [y/N]: ");
        boolean overwrite = false;
        try {
            if (this.readYes(invocation)) {
                overwrite = true;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return overwrite;
    }
}

