/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.BenchmarkCompleter;
import io.hyperfoil.cli.commands.ServerCommand;
import io.hyperfoil.cli.context.HyperfoilCliContext;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.controller.Client;
import io.hyperfoil.impl.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;

@CommandDefinition(name="new", description="Creates a new benchmark")
public class New
extends ServerCommand {
    private static final String[] TEMPLATES = new String[]{"constant", "throughput", "empty"};
    @Option(shortName=116, description="Template used to set up the benchmark.", completer=TemplateCompleter.class)
    public String template;
    @Argument(description="Name of the benchmark.", completer=BenchmarkCompleter.class)
    public String benchmark;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException, InterruptedException {
        this.ensureConnection(invocation);
        if (this.template == null) {
            invocation.println("No template was specified, available templates: ");
            invocation.println("    " + String.join((CharSequence)", ", TEMPLATES));
            invocation.print("Please select a template or keep empty for 'empty' benchmark: ");
            try {
                this.template = invocation.inputLine();
                if (this.template.isBlank()) {
                    this.template = "empty";
                }
            }
            catch (InterruptedException e) {
                invocation.println("Cancelled, not creating any benchmark.");
                return CommandResult.FAILURE;
            }
        }
        if (!Arrays.asList(TEMPLATES).contains(this.template)) {
            invocation.println("Template '" + this.template + "' is not available, please choose one of: ");
            invocation.println("    " + String.join((CharSequence)", ", TEMPLATES));
            return CommandResult.FAILURE;
        }
        HyperfoilCliContext ctx = invocation.context();
        if (this.benchmark == null || this.benchmark.isEmpty()) {
            invocation.println("Must specify benchmark name.");
            invocation.println(invocation.getHelpInfo());
            return CommandResult.FAILURE;
        }
        if (ctx.client().benchmark(this.benchmark).exists()) {
            invocation.println("Benchmark " + this.benchmark + " already exists.");
            return CommandResult.FAILURE;
        }
        ctx.setCurrentParams(Collections.emptyMap());
        InputStream resourceStream = this.getClass().getResourceAsStream("/benchmark-templates/" + this.template + ".yaml");
        if (resourceStream == null) {
            invocation.error("Template " + this.template + " was not found");
            return CommandResult.FAILURE;
        }
        try {
            String yaml = Util.toString((InputStream)resourceStream).replace("!param NAME", this.benchmark);
            Client.BenchmarkRef benchmarkRef = ctx.client().register(yaml, Collections.emptyMap(), null, null);
            ctx.setServerBenchmark(benchmarkRef);
        }
        catch (IOException e) {
            invocation.error(e);
            return CommandResult.FAILURE;
        }
        try {
            invocation.executeCommand("edit " + this.benchmark);
            return CommandResult.SUCCESS;
        }
        catch (Exception e) {
            invocation.error("Cannot execute 'edit'", e);
            return CommandResult.FAILURE;
        }
    }

    public static class TemplateCompleter
    implements OptionCompleter<CompleterInvocation> {
        public void complete(CompleterInvocation completerInvocation) {
            String prefix = completerInvocation.getGivenCompleteValue();
            for (String template : TEMPLATES) {
                if (!template.startsWith(prefix)) continue;
                completerInvocation.addCompleterValue(template);
            }
        }
    }
}

