/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.BaseStandaloneCommand;
import io.hyperfoil.cli.commands.Report;
import io.hyperfoil.cli.commands.Run;
import io.hyperfoil.cli.commands.Upload;
import io.hyperfoil.cli.commands.Wait;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.option.Option;

public class LoadAndRun
extends BaseStandaloneCommand {
    private static final String CMD = "run";

    public static void main(String[] args) {
        LoadAndRun lr = new LoadAndRun();
        lr.exec(args);
    }

    @Override
    protected Class<? extends Command<HyperfoilCommandInvocation>> getCommand() {
        return LoadAndRunCommand.class;
    }

    @Override
    protected List<Class<? extends Command<HyperfoilCommandInvocation>>> getDependencyCommands() {
        return List.of(Upload.class, Wait.class, Report.class);
    }

    @Override
    protected String getCommandName() {
        return CMD;
    }

    @CommandDefinition(name="run", description="Load and start a benchmark on Hyperfoil controller server, the argument can be the benchmark definition directly.")
    public static class LoadAndRunCommand
    extends Run {
        @Option(name="output", shortName=111, description="Output destination path for the HTML report")
        private String output;
        @Option(name="print-stack-trace", hasValue=false)
        public boolean printStackTrace;

        @Override
        protected void setup(HyperfoilCommandInvocation invocation) throws CommandException {
            if (this.benchmark == null || this.benchmark.isBlank()) {
                throw new CommandException("No benchmark file specified");
            }
            invocation.executeSwitchable("upload " + (this.printStackTrace ? "--print-stack-trace " : "") + this.benchmark);
            this.benchmark = null;
        }

        @Override
        protected void monitor(HyperfoilCommandInvocation invocation) throws CommandException {
            invocation.executeSwitchable("wait");
            if (this.output != null && !this.output.isBlank()) {
                invocation.executeSwitchable("report --silent -y --destination " + this.output);
            } else {
                invocation.println("Skipping report generation, consider providing --output to generate it.");
            }
        }
    }
}

