/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.BenchmarkCommand;
import io.hyperfoil.cli.commands.RunCompleter;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;

@CommandDefinition(name="info", description="Provides information about the benchmark.")
public class Info
extends BenchmarkCommand {
    @Option(name="pager", shortName=112, description="Pager used.")
    private String pager;
    @Option(name="run", shortName=114, description="Show benchmark used for specific run.", completer=RunCompleter.class)
    private String runId;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        this.ensureConnection(invocation);
        String benchmarkName = "<unknown>";
        try {
            Client.BenchmarkSource source;
            if (this.runId != null) {
                Client.RunRef run = invocation.context().client().run(this.runId);
                benchmarkName = run.get().benchmark;
                source = invocation.context().client().benchmark(benchmarkName).source();
            } else {
                Client.BenchmarkRef benchmarkRef = this.ensureBenchmark(invocation);
                benchmarkName = benchmarkRef.name();
                source = benchmarkRef.source();
            }
            if (source == null) {
                invocation.println("No source available for benchmark '" + benchmarkName + "'.");
            } else {
                invocation.context().createPager(this.pager).open(invocation, source.source, benchmarkName + "-", ".yaml");
            }
            return CommandResult.SUCCESS;
        }
        catch (RestClientException e) {
            invocation.error(e);
            throw new CommandException("Cannot get benchmark " + benchmarkName);
        }
    }
}

