/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BenchmarkSource;
import io.hyperfoil.cli.CliUtil;
import io.hyperfoil.cli.commands.BaseEditCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import io.hyperfoil.core.impl.ProvidedBenchmarkData;
import io.hyperfoil.core.parser.BenchmarkParser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.impl.Util;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;

@CommandDefinition(name="edit", description="Edit benchmark definition.")
public class Edit
extends BaseEditCommand {
    @Option(name="editor", shortName=101, description="Editor used.")
    private String editor;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        BenchmarkSource newSource;
        File sourceFile;
        Client.BenchmarkRef benchmarkRef = this.ensureBenchmark(invocation);
        Client.BenchmarkSource source = this.ensureSource(invocation, benchmarkRef);
        try {
            sourceFile = File.createTempFile(benchmarkRef.name() + "-", ".yaml");
            Files.write(sourceFile.toPath(), source.source.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new CommandException("Cannot create temporary file for edits.", (Throwable)e);
        }
        long modifiedTimestamp = sourceFile.lastModified();
        HashMap<String, byte[]> extraData = new HashMap<String, byte[]>();
        if (this.extraFiles != null) {
            for (String extraFile : this.extraFiles) {
                try {
                    extraData.put(extraFile, Files.readAllBytes(Path.of(extraFile, new String[0])));
                }
                catch (IOException e) {
                    invocation.error("Cannot read file " + extraFile + " (current directory is " + new File("").getAbsolutePath() + ")", e);
                }
            }
        }
        ProvidedBenchmarkData data = new ProvidedBenchmarkData(extraData);
        while (true) {
            try {
                CliUtil.execProcess(invocation, true, this.editor == null ? EDITOR : this.editor, sourceFile.getAbsolutePath());
            }
            catch (IOException e) {
                sourceFile.delete();
                throw new CommandException("Failed to invoke the editor.", (Throwable)e);
            }
            if (sourceFile.lastModified() == modifiedTimestamp) {
                invocation.println("No changes, not uploading.");
                sourceFile.delete();
                return CommandResult.SUCCESS;
            }
            try {
                String benchmark;
                byte[] updatedSource = Files.readAllBytes(sourceFile.toPath());
                newSource = BenchmarkParser.instance().createSource(new String(updatedSource, StandardCharsets.UTF_8), (BenchmarkData)data);
                if (newSource.isTemplate()) break;
                while (true) {
                    try {
                        benchmark = BenchmarkParser.instance().buildBenchmark(newSource, Collections.emptyMap());
                    }
                    catch (BenchmarkData.MissingFileException e) {
                        Path path = Path.of("<none>", new String[0]);
                        try {
                            path = CliUtil.getLocalFileForUpload(invocation, e.file);
                            if (path != null) {
                                data.files().put(e.file, Files.readAllBytes(path));
                                continue;
                            }
                            data.ignoredFiles.add(e.file);
                            continue;
                        }
                        catch (InterruptedException e2) {
                            invocation.println("Edits cancelled.");
                            sourceFile.delete();
                            return CommandResult.FAILURE;
                        }
                        catch (IOException e2) {
                            invocation.error("Cannot read file " + String.valueOf(path), e2);
                            continue;
                        }
                    }
                    break;
                }
                try {
                    Util.serialize((Benchmark)benchmark);
                }
                catch (IOException e) {
                    invocation.error("Benchmark is not serializable.", e);
                    sourceFile.delete();
                    return CommandResult.FAILURE;
                }
            }
            catch (BenchmarkDefinitionException | ParserException e) {
                invocation.error(e);
                invocation.print("Retry edits? [Y/n] ");
                try {
                    switch (invocation.inputLine().trim().toLowerCase()) {
                        case "n": 
                        case "no": {
                            return CommandResult.FAILURE;
                        }
                    }
                }
                catch (InterruptedException ie) {
                    invocation.println("Edits cancelled.");
                    sourceFile.delete();
                    return CommandResult.FAILURE;
                }
                data = new ProvidedBenchmarkData(extraData);
                continue;
            }
            catch (IOException e) {
                invocation.error(e);
                throw new CommandException("Failed to load the benchmark.", (Throwable)e);
            }
            break;
        }
        try {
            String prevVersion = source.version;
            if (!newSource.name.equals(benchmarkRef.name())) {
                invocation.println("NOTE: Renamed benchmark " + benchmarkRef.name() + " to " + newSource.name + "; old benchmark won't be deleted.");
                prevVersion = null;
            }
            invocation.println("Uploading benchmark " + newSource.name + "...");
            invocation.context().client().register(newSource.yaml, data.files(), prevVersion, benchmarkRef.name());
            sourceFile.delete();
        }
        catch (RestClientException e) {
            if (e.getCause() instanceof Client.EditConflictException) {
                switch (this.askForConflictResolution(invocation)) {
                    case CANCEL: {
                        invocation.println("You can find your edits in " + String.valueOf(sourceFile));
                        return CommandResult.SUCCESS;
                    }
                    case RETRY: {
                        try {
                            invocation.executeCommand("edit " + this.benchmark + (String)(this.editor == null ? "" : " -e " + this.editor));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return CommandResult.SUCCESS;
                    }
                    case OVERWRITE: {
                        invocation.context().client().register(newSource.yaml, data.files(), null, benchmarkRef.name());
                    }
                }
            }
            invocation.println(Util.explainCauses((Throwable)e));
            invocation.println("You can find your edits in " + String.valueOf(sourceFile));
            throw new CommandException("Failed to upload the benchmark", (Throwable)e);
        }
        invocation.println("Benchmark " + newSource.name + " updated.");
        return CommandResult.SUCCESS;
    }
}

