/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.Table;
import io.hyperfoil.cli.commands.BaseRunIdCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.controller.Client;
import java.util.Map;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;

@CommandDefinition(name="cpu", description="Show agent CPU usage")
public class Cpu
extends BaseRunIdCommand {
    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException, InterruptedException {
        String[] agents;
        Client.RunRef runRef = this.getRunRef(invocation);
        Map cpu = runRef.agentCpu();
        if (cpu == null || cpu.isEmpty()) {
            invocation.println("No agent CPU data available from run " + runRef.id() + " (maybe not completed yet).");
            return CommandResult.FAILURE;
        }
        Table table = new Table();
        table.column("PHASE", Map.Entry::getKey);
        for (String agent : agents = (String[])cpu.values().stream().flatMap(e -> e.keySet().stream()).sorted().distinct().toArray(String[]::new)) {
            table.column(agent, e -> (String)((Map)e.getValue()).get(agent));
        }
        table.print(invocation, cpu.entrySet().stream());
        return CommandResult.SUCCESS;
    }
}

