/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.api.statistics.StatisticsSummary;
import io.hyperfoil.cli.Table;
import io.hyperfoil.cli.commands.RunCompleter;
import io.hyperfoil.cli.commands.ServerCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.controller.Client;
import io.hyperfoil.controller.model.RequestStatisticsResponse;
import io.hyperfoil.controller.model.RequestStats;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;

@CommandDefinition(name="compare", description="Compare results from two runs")
public class Compare
extends ServerCommand {
    private final Table<Comparison> TABLE = new Table<Comparison>().column("PHASE", c -> c.phase).column("METRIC", c -> c.metric).column("REQUESTS", c -> this.compare((Comparison)c, ss -> ss.requestCount), Table.Align.RIGHT).column("MEAN", c -> this.compareNanos((Comparison)c, ss -> ss.meanResponseTime), Table.Align.RIGHT).column("p50", c -> this.compareNanos((Comparison)c, ss -> (Long)ss.percentileResponseTime.get(50.0)), Table.Align.RIGHT).column("p90", c -> this.compareNanos((Comparison)c, ss -> (Long)ss.percentileResponseTime.get(90.0)), Table.Align.RIGHT).column("p99", c -> this.compareNanos((Comparison)c, ss -> (Long)ss.percentileResponseTime.get(99.0)), Table.Align.RIGHT).column("p99.9", c -> this.compareNanos((Comparison)c, ss -> (Long)ss.percentileResponseTime.get(99.9)), Table.Align.RIGHT).column("p99.99", c -> this.compareNanos((Comparison)c, ss -> (Long)ss.percentileResponseTime.get(99.99)), Table.Align.RIGHT);
    @Arguments(required=true, description="Runs that should be compared.", completer=RunCompleter.class)
    private List<String> runIds;
    @Option(name="threshold", shortName=9, description="Difference threshold for coloring.", defaultValue={"0.05"})
    private double threshold;
    @Option(shortName=119, description="Include statistics from warm-up phases.", hasValue=false)
    private boolean warmup;

    private String compare(Comparison c, ToIntFunction<StatisticsSummary> f) {
        if (c.first == null || c.second == null) {
            return "N/A";
        }
        int first = f.applyAsInt(c.first);
        int second = f.applyAsInt(c.second);
        StringBuilder sb = new StringBuilder();
        double diff = (double)(second - first) / (double)Math.min(first, second);
        if (diff > this.threshold || diff < -this.threshold) {
            sb.append("\u001b[0;33m");
        }
        sb.append(String.format("%+d(%+.2f%%)", second - first, diff * 100.0));
        sb.append("\u001b[0m");
        return sb.toString();
    }

    private String compareNanos(Comparison c, ToLongFunction<StatisticsSummary> f) {
        if (c.first == null || c.second == null) {
            return "N/A";
        }
        long first = f.applyAsLong(c.first);
        long second = f.applyAsLong(c.second);
        StringBuilder sb = new StringBuilder();
        double diff = (double)(second - first) / (double)Math.min(first, second);
        if (diff > this.threshold) {
            sb.append("\u001b[0;31m");
        } else if (diff < -this.threshold) {
            sb.append("\u001b[0;32m");
        }
        sb.append(Compare.prettyPrintNanosDiff(second - first));
        sb.append(String.format("(%+.2f%%)", diff * 100.0));
        sb.append("\u001b[0m");
        return sb.toString();
    }

    public static String prettyPrintNanosDiff(long meanResponseTime) {
        if (meanResponseTime < 1000L && meanResponseTime > -1000L) {
            return String.format("%+6d ns", meanResponseTime);
        }
        if (meanResponseTime < 1000000L && meanResponseTime > -1000000L) {
            return String.format("%+6.2f \u03bcs", (double)meanResponseTime / 1000.0);
        }
        if (meanResponseTime < 1000000000L && meanResponseTime > -1000000000L) {
            return String.format("%+6.2f ms", (double)meanResponseTime / 1000000.0);
        }
        return String.format("%+6.2f s ", (double)meanResponseTime / 1.0E9);
    }

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException, InterruptedException {
        this.ensureConnection(invocation);
        if (this.runIds.size() < 2) {
            invocation.println("Two run IDs required for comparison.");
            return CommandResult.FAILURE;
        }
        if (this.runIds.size() > 2) {
            invocation.println("This command can compare only two run IDs; ignoring others.");
        }
        Client.RunRef firstRun = this.ensureComplete(invocation, this.runIds.get(0));
        Client.RunRef secondRun = this.ensureComplete(invocation, this.runIds.get(1));
        RequestStatisticsResponse firstStats = firstRun.statsTotal();
        RequestStatisticsResponse secondStats = secondRun.statsTotal();
        invocation.println("Comparing runs " + firstRun.id() + " and " + secondRun.id());
        ArrayList<Comparison> comparisons = new ArrayList<Comparison>();
        for (RequestStats stats : firstStats.statistics) {
            if (stats.isWarmup && !this.warmup) continue;
            comparisons.add(new Comparison(stats.phase, stats.metric).first(stats.summary));
        }
        for (RequestStats stats : secondStats.statistics) {
            if (stats.isWarmup && !this.warmup) continue;
            Optional<Comparison> maybeComparison = comparisons.stream().filter(c -> c.phase.equals(stats.phase) && c.metric.equals(stats.metric)).findAny();
            if (maybeComparison.isPresent()) {
                maybeComparison.get().second = stats.summary;
                continue;
            }
            comparisons.add(new Comparison(stats.phase, stats.metric).second(stats.summary));
        }
        this.TABLE.print(invocation, comparisons.stream());
        return CommandResult.SUCCESS;
    }

    private Client.RunRef ensureComplete(HyperfoilCommandInvocation invocation, String runId) throws CommandException {
        Client.RunRef firstRun = invocation.context().client().run(runId);
        if (firstRun.get().terminated == null) {
            throw new CommandException("Run " + firstRun.id() + " did not complete yet.");
        }
        return firstRun;
    }

    private static class Comparison {
        final String phase;
        final String metric;
        StatisticsSummary first;
        StatisticsSummary second;

        Comparison(String phase, String metric) {
            this.phase = phase;
            this.metric = metric;
        }

        public Comparison first(StatisticsSummary first) {
            this.first = first;
            return this;
        }

        public Comparison second(StatisticsSummary second) {
            this.second = second;
            return this;
        }
    }
}

