/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.BenchmarkCompleter;
import io.hyperfoil.cli.commands.ServerCommand;
import io.hyperfoil.cli.context.HyperfoilCliContext;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.controller.Client;
import java.util.Collections;
import org.aesh.command.CommandException;
import org.aesh.command.option.Argument;

public abstract class BenchmarkCommand
extends ServerCommand {
    @Argument(description="Name of the benchmark.", completer=BenchmarkCompleter.class)
    public String benchmark;

    protected Client.BenchmarkRef ensureBenchmark(HyperfoilCommandInvocation invocation) throws CommandException {
        Client.BenchmarkRef benchmarkRef;
        this.ensureConnection(invocation);
        HyperfoilCliContext ctx = invocation.context();
        if (this.benchmark == null || this.benchmark.isEmpty()) {
            benchmarkRef = ctx.serverBenchmark();
            if (benchmarkRef == null) {
                invocation.println("No benchmark was set. Available benchmarks: ");
                this.printList(invocation, invocation.context().client().benchmarks(), 15);
                throw new CommandException("Use " + this.getClass().getSimpleName().toLowerCase() + " <benchmark>");
            }
        } else {
            benchmarkRef = ctx.client().benchmark(this.benchmark);
            if (benchmarkRef == null) {
                invocation.println("Available benchmarks: ");
                this.printList(invocation, invocation.context().client().benchmarks(), 15);
                throw new CommandException("No such benchmark: '" + this.benchmark + "'");
            }
            if (ctx.serverBenchmark() != null && !ctx.serverBenchmark().name().equals(this.benchmark)) {
                ctx.setCurrentParams(Collections.emptyMap());
            }
        }
        ctx.setServerBenchmark(benchmarkRef);
        return benchmarkRef;
    }
}

