/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.BaseRunIdCommand;
import io.hyperfoil.controller.Client;
import java.util.stream.Stream;
import org.aesh.command.CommandException;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.option.Option;

public abstract class BaseExportCommand
extends BaseRunIdCommand {
    @Option(shortName=102, description="Format in which should the statistics exported. Options are JSON (default) and CSV.", defaultValue={"JSON"}, completer=FormatCompleter.class)
    public String format;

    protected String getDefaultFilename(Client.RunRef runRef) throws CommandException {
        switch (this.format.toUpperCase()) {
            case "JSON": {
                return runRef.id() + ".json";
            }
            case "CSV": {
                return runRef.id() + ".zip";
            }
        }
        throw new CommandException("Unknown format '" + this.format + "', please use JSON or CSV");
    }

    protected String getAcceptFormat() throws CommandException {
        switch (this.format.toUpperCase()) {
            case "JSON": {
                return "application/json";
            }
            case "CSV": {
                return "application/zip";
            }
        }
        throw new CommandException("Unknown format '" + this.format + "', please use JSON or CSV");
    }

    public static class FormatCompleter
    implements OptionCompleter<CompleterInvocation> {
        public void complete(CompleterInvocation completerInvocation) {
            Stream<String> formats = Stream.of("JSON", "CSV");
            String prefix = completerInvocation.getGivenCompleteValue();
            if (prefix != null) {
                formats = formats.filter(b -> b.startsWith(prefix));
            }
            formats.forEach(arg_0 -> ((CompleterInvocation)completerInvocation).addCompleterValue(arg_0));
        }
    }
}

