/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.BenchmarkCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import java.util.List;
import org.aesh.command.CommandException;
import org.aesh.command.option.OptionList;

public abstract class BaseEditCommand
extends BenchmarkCommand {
    @OptionList(name="extra-files", shortName=102, description="Extra files for upload (comma-separated) in case this benchmark is a template and files won't be auto-detected. Example: --extra-files foo.txt,bar.txt")
    protected List<String> extraFiles;

    protected ConflictResolution askForConflictResolution(HyperfoilCommandInvocation invocation) {
        invocation.println("Conflict: the benchmark was modified while being edited.");
        try {
            while (true) {
                invocation.print("Options: [C]ancel edit, [r]etry edits, [o]verwrite: ");
                switch (invocation.inputLine().trim().toLowerCase()) {
                    case "": 
                    case "c": {
                        invocation.println("Edit cancelled.");
                        return ConflictResolution.CANCEL;
                    }
                    case "r": {
                        return ConflictResolution.RETRY;
                    }
                    case "o": {
                        return ConflictResolution.OVERWRITE;
                    }
                }
            }
        }
        catch (InterruptedException ie) {
            invocation.println("Edit cancelled by interrupt.");
            return ConflictResolution.CANCEL;
        }
    }

    protected Client.BenchmarkSource ensureSource(HyperfoilCommandInvocation invocation, Client.BenchmarkRef benchmarkRef) throws CommandException {
        Client.BenchmarkSource source;
        try {
            source = benchmarkRef.source();
            if (source == null) {
                throw new CommandException("No source available for benchmark '" + benchmarkRef.name() + "', cannot edit.");
            }
        }
        catch (RestClientException e) {
            invocation.error(e);
            throw new CommandException("Cannot get benchmark " + benchmarkRef.name());
        }
        if (source.version == null) {
            invocation.warn("Server did not send benchmark source version, modification conflicts won't be prevented.");
        }
        return source;
    }

    protected static enum ConflictResolution {
        CANCEL,
        RETRY,
        OVERWRITE;

    }
}

