/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli;

import io.hyperfoil.cli.CliUtil;
import io.hyperfoil.cli.Pager;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.aesh.command.CommandException;

public class ProcessPager
implements Pager {
    private static final String PAGER;
    private final String pager;

    public ProcessPager(String pager) {
        this.pager = pager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(HyperfoilCommandInvocation invocation, String text, String prefix, String suffix) throws CommandException {
        File file;
        try {
            file = File.createTempFile(prefix, suffix);
            file.deleteOnExit();
            Files.write(file.toPath(), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new CommandException("Cannot create temporary file for edits.", (Throwable)e);
        }
        try {
            this.open(invocation, file);
        }
        finally {
            file.delete();
        }
    }

    @Override
    public void open(HyperfoilCommandInvocation invocation, File file) throws CommandException {
        try {
            CliUtil.execProcess(invocation, true, this.pager == null ? PAGER : this.pager, file.getPath());
        }
        catch (IOException e) {
            throw new CommandException("Cannot open file " + String.valueOf(file), (Throwable)e);
        }
    }

    static {
        String pager = System.getenv("PAGER");
        if (pager == null || pager.isEmpty()) {
            pager = CliUtil.fromCommand("update-alternatives", "--display", "pager");
        }
        if (pager == null || pager.isEmpty()) {
            pager = CliUtil.fromCommand("git", "var", "GIT_PAGER");
        }
        if (pager == null || pager.isEmpty()) {
            pager = "less";
        }
        PAGER = pager;
    }
}

