/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli;

import io.hyperfoil.cli.CliUtil;
import io.hyperfoil.cli.commands.Compare;
import io.hyperfoil.cli.commands.Connect;
import io.hyperfoil.cli.commands.Connections;
import io.hyperfoil.cli.commands.Cpu;
import io.hyperfoil.cli.commands.Edit;
import io.hyperfoil.cli.commands.Exit;
import io.hyperfoil.cli.commands.Export;
import io.hyperfoil.cli.commands.Forget;
import io.hyperfoil.cli.commands.Help;
import io.hyperfoil.cli.commands.Info;
import io.hyperfoil.cli.commands.Inspect;
import io.hyperfoil.cli.commands.Kill;
import io.hyperfoil.cli.commands.Load;
import io.hyperfoil.cli.commands.Log;
import io.hyperfoil.cli.commands.New;
import io.hyperfoil.cli.commands.Report;
import io.hyperfoil.cli.commands.Run;
import io.hyperfoil.cli.commands.Runs;
import io.hyperfoil.cli.commands.Sessions;
import io.hyperfoil.cli.commands.Shutdown;
import io.hyperfoil.cli.commands.StartLocal;
import io.hyperfoil.cli.commands.Stats;
import io.hyperfoil.cli.commands.Status;
import io.hyperfoil.cli.commands.Upload;
import io.hyperfoil.cli.commands.Version;
import io.hyperfoil.cli.commands.Wait;
import io.hyperfoil.cli.commands.Wrk;
import io.hyperfoil.cli.commands.Wrk2;
import io.hyperfoil.cli.context.HyperfoilCliContext;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.cli.context.HyperfoilCommandInvocationProvider;
import io.hyperfoil.cli.context.HyperfoilCompleterData;
import io.hyperfoil.impl.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aesh.AeshConsoleRunner;
import org.aesh.command.Command;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.converter.ConverterInvocation;
import org.aesh.command.impl.registry.AeshCommandRegistryBuilder;
import org.aesh.command.invocation.CommandInvocationProvider;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.registry.CommandRegistryException;
import org.aesh.command.settings.Settings;
import org.aesh.command.settings.SettingsBuilder;
import org.aesh.command.validator.ValidatorInvocation;
import org.aesh.readline.Prompt;
import org.aesh.readline.terminal.formatting.Color;
import org.aesh.readline.terminal.formatting.TerminalColor;
import org.aesh.readline.terminal.formatting.TerminalString;

public class HyperfoilCli {
    public static final String CLI_PROMPT = "CLI_PROMPT";

    public static void main(String[] args) throws CommandRegistryException {
        new HyperfoilCli().run();
    }

    public void run() throws CommandRegistryException {
        HyperfoilCliContext context = new HyperfoilCliContext();
        AeshConsoleRunner runner = this.configureRunner(context, this.settingsBuilder(context, new HyperfoilCommandInvocationProvider(context)).build(), System.getenv(CLI_PROMPT));
        CompletableFuture<List<String>> endpoints = HyperfoilCli.suggestedEndpoints();
        endpoints.whenComplete((list, e) -> {
            if (e == null && !list.isEmpty()) {
                context.setSuggestedControllerHosts((List<String>)list);
            }
        });
        runner.start();
    }

    protected AeshConsoleRunner configureRunner(HyperfoilCliContext context, Settings<? extends HyperfoilCommandInvocation, ConverterInvocation, CompleterInvocation, ValidatorInvocation<?, ?>, OptionActivator, CommandActivator> settings, String cliPrompt) {
        context.commandRegistry((CommandRegistry<? extends HyperfoilCommandInvocation>)settings.commandRegistry());
        AeshConsoleRunner runner = AeshConsoleRunner.builder().settings(settings);
        if (cliPrompt == null) {
            runner.prompt(new Prompt(new TerminalString("[hyperfoil]$ ", new TerminalColor(Color.GREEN, Color.DEFAULT, Color.Intensity.BRIGHT))));
        } else {
            runner.prompt(new Prompt(cliPrompt));
        }
        return runner;
    }

    protected <CI extends HyperfoilCommandInvocation> SettingsBuilder<HyperfoilCommandInvocation, ConverterInvocation, CompleterInvocation, ValidatorInvocation<?, ?>, OptionActivator, CommandActivator> settingsBuilder(HyperfoilCliContext context, CommandInvocationProvider<CI> commandInvocationProvider) throws CommandRegistryException {
        AeshCommandRegistryBuilder commandRegistryBuilder = AeshCommandRegistryBuilder.builder();
        for (Class<? extends Command> command : this.getCommands()) {
            commandRegistryBuilder.command(command);
        }
        return SettingsBuilder.builder().logging(true).enableMan(false).enableAlias(false).enableExport(false).enableSearchInPaging(true).readInputrc(true).commandRegistry(commandRegistryBuilder.create()).commandInvocationProvider(commandInvocationProvider).completerInvocationProvider(completerInvocation -> new HyperfoilCompleterData(completerInvocation, context)).setConnectionClosedHandler(nil -> context.stop());
    }

    protected List<Class<? extends Command>> getCommands() {
        return Arrays.asList(Connect.class, Connections.class, Compare.class, Cpu.class, Edit.class, Exit.class, Export.class, Forget.class, Help.class, Info.class, Inspect.class, Kill.class, Load.class, Log.class, New.class, Report.class, Run.class, Runs.class, Sessions.class, Shutdown.class, StartLocal.class, Stats.class, Status.class, Upload.class, Version.class, Wait.class, Wrk.WrkCommand.class, Wrk2.Wrk2Command.class);
    }

    private static CompletableFuture<List<String>> suggestedEndpoints() {
        CompletableFuture openshiftPorts;
        try {
            Process start = new ProcessBuilder("oc", "get", "route", "-A", "-l", "hyperfoil", "-o", "jsonpath={range .items[*]}{.spec.tls.termination}:{.status.ingress[0].host} ").start();
            openshiftPorts = CompletableFuture.supplyAsync(() -> {
                try {
                    return Stream.of(Util.toString((InputStream)start.getInputStream()).split("[ \\n\\t]+")).map(endpoint -> {
                        int index = endpoint.indexOf(58);
                        String prefix = index == 0 ? "http://" : "https://";
                        return prefix + endpoint.substring(index + 1);
                    }).collect(Collectors.toList());
                }
                catch (IOException e) {
                    return Collections.emptyList();
                }
            });
        }
        catch (IOException e) {
            openshiftPorts = CompletableFuture.completedFuture(Collections.emptyList());
        }
        return openshiftPorts.thenApply(list -> {
            if (CliUtil.isPortListening("localhost", 8090)) {
                ArrayList<String> copy = new ArrayList<String>((Collection<String>)list);
                copy.add("localhost:8090");
                return copy;
            }
            return list;
        });
    }

    static {
        Handler[] handlers = Logger.getLogger("").getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            handlers[index].setLevel(Level.SEVERE);
        }
    }
}

