/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.controller;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.statistics.StatisticsSummary;
import io.hyperfoil.controller.model.Histogram;
import io.hyperfoil.controller.model.RequestStatisticsResponse;
import io.hyperfoil.controller.model.Run;
import io.hyperfoil.controller.model.Version;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface Client {
    public BenchmarkRef register(Benchmark var1, String var2);

    public BenchmarkRef register(String var1, Map<String, byte[]> var2, String var3, String var4);

    public BenchmarkRef register(Path var1, Map<String, Path> var2, String var3, String var4);

    public BenchmarkRef registerLocal(String var1, String var2, String var3);

    public List<String> benchmarks();

    public List<String> templates();

    public BenchmarkRef benchmark(String var1);

    public List<Run> runs(boolean var1);

    public RunRef run(String var1);

    public long ping();

    public Version version();

    public Collection<String> agents();

    public String downloadLog(String var1, String var2, long var3, long var5, File var7);

    public void shutdown(boolean var1);

    public static class EditConflictException
    extends RuntimeException {
    }

    public static class MinMax {
        public final int min;
        public final int max;

        @JsonCreator
        public MinMax(@JsonProperty(value="min") int min, @JsonProperty(value="max") int max) {
            this.min = min;
            this.max = max;
        }
    }

    public static interface RunRef {
        public String id();

        public Run get();

        public RunRef kill();

        public Benchmark benchmark();

        public Map<String, Map<String, MinMax>> sessionStatsRecent();

        public Map<String, Map<String, MinMax>> sessionStatsTotal();

        public Collection<String> sessions();

        public Collection<String> connections();

        public Map<String, Map<String, MinMax>> connectionStatsRecent();

        public Map<String, Map<String, MinMax>> connectionStatsTotal();

        public RequestStatisticsResponse statsRecent();

        public RequestStatisticsResponse statsTotal();

        public byte[] statsAll(String var1);

        public Histogram histogram(String var1, int var2, String var3);

        public List<StatisticsSummary> series(String var1, int var2, String var3);

        public byte[] file(String var1);

        public byte[] report(String var1);

        public Map<String, Map<String, String>> agentCpu();
    }

    public static class BenchmarkStructure {
        public final Map<String, String> params;
        public final String content;

        @JsonCreator
        public BenchmarkStructure(@JsonProperty(value="params") Map<String, String> params, @JsonProperty(value="content") String content) {
            this.params = params;
            this.content = content;
        }
    }

    public static class BenchmarkSource {
        public final String source;
        public final String version;
        public final Collection<String> files;

        public BenchmarkSource(String source, String version, Collection<String> files) {
            this.source = source;
            this.version = version;
            this.files = files;
        }
    }

    public static interface BenchmarkRef {
        public String name();

        public BenchmarkSource source();

        public Benchmark get();

        public RunRef start(String var1, Map<String, String> var2);

        public RunRef start(String var1, Map<String, String> var2, Boolean var3);

        public BenchmarkStructure structure(Integer var1, Map<String, String> var2);

        public Map<String, byte[]> files();

        public boolean exists();

        public boolean forget();
    }
}

