/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.example;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.IntAccess;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.session.SessionFactory;
import java.util.Collections;
import java.util.List;

public class DivideStep
implements Step {
    private final ReadAccess fromVar;
    private final IntAccess toVar;
    private final int divisor;

    public DivideStep(ReadAccess fromVar, IntAccess toVar, int divisor) {
        this.fromVar = fromVar;
        this.toVar = toVar;
        this.divisor = divisor;
    }

    public boolean invoke(Session session) {
        if (!this.fromVar.isSet(session)) {
            return false;
        }
        int value = this.fromVar.getInt(session);
        this.toVar.setInt(session, value / this.divisor);
        return true;
    }

    @Name(value="divide")
    public static class Builder
    extends BaseStepBuilder<Builder>
    implements InitFromParam<Builder> {
        private String fromVar;
        private String toVar;
        private int divisor;

        public Builder init(String param) {
            int divIndex = param.indexOf("/=");
            if (divIndex < 0) {
                throw new BenchmarkDefinitionException("Invalid inline definition: " + param);
            }
            try {
                this.divisor(Integer.parseInt(param.substring(divIndex + 2).trim()));
            }
            catch (NumberFormatException e) {
                throw new BenchmarkDefinitionException("Invalid inline definition: " + param, (Throwable)e);
            }
            String var = param.substring(0, divIndex).trim();
            return this.fromVar(var).toVar(var);
        }

        public Builder fromVar(String fromVar) {
            this.fromVar = fromVar;
            return this;
        }

        public Builder toVar(String toVar) {
            this.toVar = toVar;
            return this;
        }

        public Builder divisor(int divisor) {
            this.divisor = divisor;
            return this;
        }

        public List<Step> build() {
            if (this.fromVar == null || this.toVar == null || this.divisor == 0) {
                throw new BenchmarkDefinitionException("Missing one of the required attributes!");
            }
            return Collections.singletonList(new DivideStep(SessionFactory.readAccess((Object)this.fromVar), SessionFactory.intAccess((Object)this.toVar), this.divisor));
        }
    }
}

