/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.metainf_services;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.kohsuke.MetaInfServices;

@SupportedAnnotationTypes(value={"org.kohsuke.MetaInfServices"})
public class AnnotationProcessorImpl
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        FileObject f;
        if (roundEnv.processingOver()) {
            return false;
        }
        HashMap<String, TreeSet<String>> services = new HashMap<String, TreeSet<String>>();
        Elements elements = this.processingEnv.getElementUtils();
        for (Element element : roundEnv.getElementsAnnotatedWith(MetaInfServices.class)) {
            TypeElement type;
            Collection<TypeElement> contracts;
            MetaInfServices a = element.getAnnotation(MetaInfServices.class);
            if (a == null || !element.getKind().isClass() && !element.getKind().isInterface() || (contracts = this.getContracts(type = (TypeElement)element, a)).isEmpty()) continue;
            for (TypeElement contract2 : contracts) {
                String cn = elements.getBinaryName(contract2).toString();
                TreeSet<String> v = (TreeSet<String>)services.get(cn);
                if (v == null) {
                    v = new TreeSet<String>();
                    services.put(cn, v);
                }
                v.add(elements.getBinaryName(type).toString());
            }
        }
        Filer filer = this.processingEnv.getFiler();
        for (Map.Entry e : services.entrySet()) {
            try {
                String line;
                String contract3 = (String)e.getKey();
                f = filer.getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + contract3);
                BufferedReader r = new BufferedReader(new InputStreamReader(f.openInputStream(), "UTF-8"));
                while ((line = r.readLine()) != null) {
                    ((Set)e.getValue()).add(line);
                }
                r.close();
            }
            catch (FileNotFoundException contract3) {
            }
            catch (NoSuchFileException contract3) {
            }
            catch (IOException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to load existing service definition files: " + x);
            }
        }
        for (Map.Entry e : services.entrySet()) {
            try {
                String contract = (String)e.getKey();
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Writing META-INF/services/" + contract);
                f = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + contract, new Element[0]);
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(f.openOutputStream(), "UTF-8"));
                for (String value : (Set)e.getValue()) {
                    pw.println(value);
                }
                pw.close();
            }
            catch (IOException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write service definition files: " + x);
            }
        }
        return false;
    }

    private Collection<TypeElement> getContracts(TypeElement type, MetaInfServices a) {
        ArrayList<TypeElement> typeElementList = new ArrayList<TypeElement>();
        try {
            a.value();
            throw new AssertionError();
        }
        catch (MirroredTypesException e) {
            for (TypeMirror typeMirror : e.getTypeMirrors()) {
                if (typeMirror.getKind() == TypeKind.VOID) {
                    boolean hasInterfaces;
                    boolean hasBaseClass = type.getSuperclass().getKind() != TypeKind.NONE && !this.isObject(type.getSuperclass());
                    boolean bl = hasInterfaces = !type.getInterfaces().isEmpty();
                    if (hasBaseClass ^ hasInterfaces) {
                        if (hasBaseClass) {
                            typeElementList.add((TypeElement)((DeclaredType)type.getSuperclass()).asElement());
                            continue;
                        }
                        typeElementList.add((TypeElement)((DeclaredType)type.getInterfaces().get(0)).asElement());
                        continue;
                    }
                    this.error(type, "Contract type was not specified, but it couldn't be inferred.");
                    continue;
                }
                if (typeMirror instanceof DeclaredType) {
                    DeclaredType dt = (DeclaredType)typeMirror;
                    typeElementList.add((TypeElement)dt.asElement());
                    continue;
                }
                this.error(type, "Invalid type specified as the contract");
            }
            return typeElementList;
        }
    }

    private boolean isObject(TypeMirror t) {
        if (t instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)t;
            return ((TypeElement)dt.asElement()).getQualifiedName().toString().equals("java.lang.Object");
        }
        return false;
    }

    private void error(Element source, String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, source);
    }
}

