/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.VersionedMetadataImpl;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.operations.GetStreamStartResponse;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class GetStreamStartOperation
extends AbstractKeyOperation<GetStreamStartResponse> {
    private final int batchSize;

    protected GetStreamStartOperation(InternalRemoteCache<?, ?> internalRemoteCache, byte[] keyBytes, int batchSize) {
        super(internalRemoteCache, keyBytes);
        this.batchSize = batchSize;
    }

    @Override
    public void writeOperationRequest(Channel channel, ByteBuf buf, Codec codec) {
        super.writeOperationRequest(channel, buf, codec);
        ByteBufUtil.writeVInt(buf, this.batchSize);
    }

    @Override
    public GetStreamStartResponse createResponse(ByteBuf buf, short status, HeaderDecoder decoder, Codec codec, CacheUnmarshaller unmarshaller) {
        if (!HotRodConstants.isNotExist(status) && HotRodConstants.isSuccess(status)) {
            int id = buf.readInt();
            boolean complete = buf.readBoolean();
            short flags = buf.readUnsignedByte();
            long creation = -1L;
            int lifespan = -1;
            long lastUsed = -1L;
            int maxIdle = -1;
            if ((flags & 1) != 1) {
                creation = buf.readLong();
                lifespan = ByteBufUtil.readVInt(buf);
            }
            if ((flags & 2) != 2) {
                lastUsed = buf.readLong();
                maxIdle = ByteBufUtil.readVInt(buf);
            }
            long version = buf.readLong();
            VersionedMetadataImpl versionedMetadata = new VersionedMetadataImpl(creation, lifespan, lastUsed, maxIdle, version);
            int length = ByteBufUtil.readVInt(buf);
            ByteBuf value = buf.readRetainedSlice(length);
            return new GetStreamStartResponse(id, complete, value, versionedMetadata, decoder.getChannel());
        }
        return null;
    }

    @Override
    public short requestOpCode() {
        return 233;
    }

    @Override
    public short responseOpCode() {
        return 232;
    }
}

