/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.client.hotrod.counter.operation.BaseCounterOperation;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;

public class AddOperation
extends BaseCounterOperation<Long> {
    private final long delta;

    public AddOperation(String counterName, long delta, boolean useConsistentHash) {
        super(counterName, useConsistentHash);
        this.delta = delta;
    }

    @Override
    public void writeOperationRequest(Channel channel, ByteBuf buf, Codec codec) {
        super.writeOperationRequest(channel, buf, codec);
        buf.writeLong(this.delta);
    }

    private void assertBoundaries(short status) {
        if (status == 4) {
            if (this.delta > 0L) {
                throw Log.HOTROD.counterOurOfBounds("Upper bound");
            }
            throw Log.HOTROD.counterOurOfBounds("Lower bound");
        }
    }

    @Override
    public Long createResponse(ByteBuf buf, short status, HeaderDecoder decoder, Codec codec, CacheUnmarshaller unmarshaller) {
        this.checkStatus(status);
        this.assertBoundaries(status);
        assert (status == 0);
        return buf.readLong();
    }

    @Override
    public short requestOpCode() {
        return 82;
    }

    @Override
    public short responseOpCode() {
        return 83;
    }
}

